/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.BOCNET_BusTypeUtil;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.item.TransTypeEnum;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    static final int PAGE_SIZE = 50;

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("1");
        boolean lastPage = false;
        this.setLastPage(lastPage);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(request);
            if (Objects.nonNull(response) && Objects.nonNull(response.getDetails())) {
                detailInfos.addAll(response.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 50);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankDetailRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            BankAcnt acnt = request.getHeader().getAcnt();
            String accNo = acnt.getAccNo();
            Element root = Packer.getHeader(token, "b2e0035");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0035-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0035-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)acnt.getCnaps());
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)accNo);
            String type = "2002";
            if (LocalDate.now().isEqual(request.getEndDate())) {
                type = "2001";
            }
            JDomUtils.addChild((Element)rq, (String)"type", (String)type);
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)datescope, (String)"to", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            Element amountscope = JDomUtils.addChild((Element)rq, (String)"amountscope");
            JDomUtils.addChild((Element)amountscope, (String)"from", (String)"0.01");
            JDomUtils.addChild((Element)amountscope, (String)"to", (String)"9999999999999");
            JDomUtils.addChild((Element)rq, (String)"begnum", (String)this.getCurrentPage());
            JDomUtils.addChild((Element)rq, (String)"recnum", (String)String.valueOf(50));
            JDomUtils.addChild((Element)rq, (String)"direction", (String)"0");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0035-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("B001".equalsIgnoreCase(rspcod) || "B003".equalsIgnoreCase(rspcod)) {
            this.setLastPage(true);
        } else if ("B002".equalsIgnoreCase(rspcod)) {
            this.setLastPage(false);
        }
        if ("B003".equalsIgnoreCase(rspcod)) {
            return new EBBankDetailResponse(detailList);
        }
        if (!"B001".equalsIgnoreCase(rspcod) && !"B002".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25:%s\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), rspcod + rspmsg));
        }
        List list = trn.getChildren("b2e0035-rs");
        if (null == list || list.size() == 0) {
            return new EBBankDetailResponse(list);
        }
        for (Element record : list) {
            DetailInfo info;
            if (!"b2e0035-rs".equalsIgnoreCase(record.getName()) || (info = this.parseEachDetailB2e0035(record, request.getHeader().getAcnt())) == null) continue;
            detailList.add(info);
        }
        return new EBBankDetailResponse(detailList);
    }

    private DetailInfo parseEachDetailB2e0035(Element record, BankAcnt acnt) {
        Element status = record.getChild("status");
        Element rspCode = status.getChild("rspcod");
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        if ("B001".equalsIgnoreCase(rspCode.getTextTrim())) {
            String vchnum;
            String KDDetailNo;
            Element fractn = record.getChild("fractn");
            String payAcntNumber = fractn.getChildTextTrim("actacn");
            if (!StringUtils.isEmpty((String)payAcntNumber) && payAcntNumber.contains(acnt.getAccNo())) {
                payAcntNumber = acnt.getAccNo();
            }
            String payAcntName = fractn.getChildTextTrim("acntname");
            String payAcntBankName = fractn.getChildTextTrim("ibkname");
            BankAcnt payAcnt = new BankAcnt();
            payAcnt.setAccName(StrUtil.nullToEmpty((CharSequence)payAcntName));
            payAcnt.setAccNo(StrUtil.nullToEmpty((CharSequence)payAcntNumber));
            payAcnt.setBankName(StrUtil.nullToEmpty((CharSequence)payAcntBankName));
            Element toactn = record.getChild("toactn");
            String oppAcntNumber = toactn.getChildTextTrim("actacn");
            if (!StringUtils.isEmpty((String)oppAcntNumber) && oppAcntNumber.contains(acnt.getAccNo())) {
                oppAcntNumber = acnt.getAccNo();
            }
            String oppAcntName = toactn.getChildTextTrim("toname");
            String oppAcntBankName = toactn.getChildTextTrim("tobank");
            BankAcnt oppPayAcnt = new BankAcnt();
            oppPayAcnt.setAccName(StrUtil.nullToEmpty((CharSequence)oppAcntName));
            oppPayAcnt.setAccNo(StrUtil.nullToEmpty((CharSequence)oppAcntNumber));
            oppPayAcnt.setBankName(StrUtil.nullToEmpty((CharSequence)oppAcntBankName));
            String agentAccNo = record.getChildTextTrim("mactacn");
            String agentAccName = record.getChildTextTrim("mactname");
            String agentAccBkName = record.getChildTextTrim("mactbank");
            String transtype = record.getChildTextTrim("transtype");
            String insid = record.getChildTextTrim("insid");
            String reserve1 = record.getChildTextTrim("reserve1");
            String reserve2 = record.getChildTextTrim("reserve2");
            StringBuilder extMessage = new StringBuilder("EXT_MSG:");
            extMessage.append("insid=").append(insid).append(";reserve1=").append(reserve1).append(";reserve2=").append(reserve2);
            String txndate = record.getChildTextTrim("txndate");
            String txntime = record.getChildTextTrim("txntime");
            String txnamt = record.getChildTextTrim("txnamt");
            String trncur = record.getChildTextTrim("trncur");
            String acctbal = record.getChildTextTrim("acctbal");
            String transid = record.getChildTextTrim("transid");
            String bustype = record.getChildTextTrim("bustype");
            String useinfo = StrUtil.nullToEmpty((CharSequence)record.getChildTextTrim("useinfo"));
            String interinfo = StrUtil.nullToEmpty((CharSequence)record.getChildTextTrim("interinfo"));
            String direction = record.getChildText("direction");
            if (StrUtil.isEmpty((String)direction)) {
                this.log.info("[<direction> \u6765\u5f80\u8d26\u6807\u8bc6\uff081-\u6765\u8d26\uff0c2-\u5f80\u8d26\uff09]\u8282\u70b9\u7684\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4ea4\u6613\u660e\u7ec6\u501f\u8d37\u65b9\u5411\u3002\u672c\u6761\u4ea4\u6613\u660e\u7ec6\u65e0\u6548\u3002");
                return null;
            }
            DetailInfo detail = new DetailInfo();
            if (StringUtils.isEmpty((String)txntime)) {
                txntime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
            }
            detail.setTransDate(LocalDate.parse(txndate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(txndate + txntime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            DetailSysFiled.set((DetailInfo)detail, (String)"agentAccNo", (String)agentAccNo);
            detail.setAgentAccNo(agentAccNo);
            DetailSysFiled.set((DetailInfo)detail, (String)"agentAccName", (String)agentAccName);
            detail.setAgentAccName(agentAccName);
            DetailSysFiled.set((DetailInfo)detail, (String)"agentAccBkName", (String)agentAccBkName);
            detail.setAgentAccBankName(agentAccBkName);
            String busTypeDesc = BOCNET_BusTypeUtil.instance().getBusTypeByCode(bustype);
            DetailSysFiled.set((DetailInfo)detail, (String)"busType", (String)busTypeDesc);
            DetailSysFiled.set((DetailInfo)detail, (String)"transtype", (String)transtype);
            DetailSysFiled.set((DetailInfo)detail, (String)"businessName", (String)extMessage.toString());
            if (!StrUtil.isEmpty((String)bustype)) {
                if ("0023".equalsIgnoreCase(bustype) || "7501".equalsIgnoreCase(bustype)) {
                    detail.setTransType("autotransup");
                } else if ("0024".equalsIgnoreCase(bustype) || "7502".equalsIgnoreCase(bustype)) {
                    detail.setTransType("autotransdown");
                }
            }
            BigDecimal amt = new BigDecimal(txnamt);
            if ("11".equalsIgnoreCase(transtype)) {
                amt = amt.multiply(new BigDecimal("-1"));
            } else if ("22".equals(transtype)) {
                detail.setTransType(TransTypeEnum.REFUND.getName());
            }
            if ("1".equalsIgnoreCase(direction)) {
                detail.setAccNo(oppPayAcnt.getAccNo());
                detail.setAccName(oppPayAcnt.getAccName());
                detail.setBankName(oppPayAcnt.getBankName());
                if (BankBusinessConfig.isOtherAcntToProxyAcnt() && StringUtils.isNotEmpty((String)agentAccNo)) {
                    detail.setOppAccNo(agentAccNo);
                    detail.setOppAccName(agentAccName);
                    detail.setOppBankName(agentAccBkName);
                } else {
                    detail.setOppAccNo(payAcnt.getAccNo());
                    detail.setOppAccName(payAcnt.getAccName());
                    detail.setOppBankName(payAcnt.getBankName());
                }
                detail.setCreditAmount(amt);
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("2".equalsIgnoreCase(direction)) {
                detail.setAccNo(payAcnt.getAccNo());
                detail.setAccName(payAcnt.getAccName());
                detail.setBankName(payAcnt.getBankName());
                if (BankBusinessConfig.isOtherAcntToProxyAcnt() && StringUtils.isNotEmpty((String)agentAccNo)) {
                    detail.setOppAccNo(agentAccNo);
                    detail.setOppAccName(agentAccName);
                    detail.setOppBankName(agentAccBkName);
                } else {
                    detail.setOppAccNo(oppPayAcnt.getAccNo());
                    detail.setOppAccName(oppPayAcnt.getAccName());
                    detail.setOppBankName(oppPayAcnt.getBankName());
                }
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(amt);
            } else {
                this.log.info("[<direction> \u6765\u5f80\u8d26\u6807\u8bc6\uff081-\u6765\u8d26\uff0c2-\u5f80\u8d26\uff09]\u8282\u70b9\u7684\u503c[" + direction + "]\u672a\u77e5\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4ea4\u6613\u660e\u7ec6\u501f\u8d37\u65b9\u5411\u3002\u672c\u6761\u4ea4\u6613\u660e\u7ec6\u65e0\u6548\u3002");
                return null;
            }
            if (!StrUtil.isEmpty((String)acctbal)) {
                detail.setBalance(new BigDecimal(acctbal));
            }
            detail.setTransTime(LocalDateTime.parse(txndate + txntime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            detail.setCurrency(trncur);
            if (!StrUtil.isEmpty((String)insid) && insid.indexOf("KD_") != -1) {
                KDDetailNo = insid.substring(insid.indexOf("KD_") + "KD_".length());
                detail.setKdFlag(KDDetailNo);
                detail.setPayBankDetailSeqID(KDDetailNo);
            } else if (!StrUtil.isEmpty((String)insid) && insid.indexOf("KD") != -1 && insid.length() > 8) {
                KDDetailNo = insid.substring(insid.indexOf("KD") + "KD".length());
                detail.setKdFlag(KDDetailNo);
                detail.setPayBankDetailSeqID(KDDetailNo);
            }
            detail.setExplanation(this.composeMsg(this.extractF(interinfo), this.extractA(interinfo), this.extractU(interinfo), this.extractR(interinfo)));
            if (StringUtils.isEmpty((String)detail.getExplanation())) {
                detail.setExplanation(busTypeDesc);
            }
            if (!StrUtil.isEmpty((String)(vchnum = record.getChildTextTrim("vchnum")))) {
                detail.setBizRefNo(vchnum);
            }
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(acnt.getAccNo()).append("-").append(txndate).append("-").append(vchnum);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            String accNo = acnt.getAccNo();
            String transDate = txndate;
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(vchnum);
            StringBuilder sortFiled = new StringBuilder();
            sortFiled.append(txndate).append("|").append(txntime).append("|").append(transid);
            detail.setSortField(sortFiled.toString());
            String billNo = record.getChildTextTrim("vouchnum");
            if (!StrUtil.isEmpty((String)billNo)) {
                detail.setVouhNo(billNo);
            }
            return detail;
        }
        this.log.info("\u5927\u5ba2\u6237\u4ea4\u6613\u4fe1\u606f\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u72b6\u6001(rspcod\u4e0d\u662fB001,\u94f6\u4f01\u4e0d\u5904\u7406)" + rspCode.getTextTrim() + "," + status.getTextTrim());
        return null;
    }

    private String extractU(String interinfo) {
        int endIndex;
        int index = interinfo.indexOf("//U:");
        if (-1 != index && index <= (endIndex = interinfo.indexOf("//R:", index))) {
            return interinfo.substring(index + 4, endIndex);
        }
        return "";
    }

    private String extractF(String interinfo) {
        int endIndex;
        int index = interinfo.indexOf("F:");
        if (-1 != index && index <= (endIndex = interinfo.indexOf("//A:", index))) {
            return interinfo.substring(index + 2, endIndex);
        }
        return "";
    }

    private String extractA(String interinfo) {
        int endIndex;
        int index = interinfo.indexOf("//A:");
        if (-1 != index && index <= (endIndex = interinfo.indexOf("//U:", index))) {
            return interinfo.substring(index + 4, endIndex);
        }
        return "";
    }

    private String extractR(String interinfo) {
        int index = interinfo.indexOf("//R:");
        if (-1 != index) {
            return interinfo.substring(index + 4);
        }
        return "";
    }

    private String composeMsg(String postscript, String explanation, String useCn, String beizhu) {
        String msg;
        int index;
        StringBuilder buffer = new StringBuilder();
        if (!StrUtil.isEmpty((String)postscript)) {
            buffer.append(postscript).append(',');
        }
        if (!StrUtil.isEmpty((String)explanation) && -1 == buffer.toString().indexOf(explanation) && !explanation.startsWith("OBSS")) {
            buffer.append(explanation).append(',');
        }
        if (!StrUtil.isEmpty((String)useCn) && -1 == buffer.toString().indexOf(useCn)) {
            buffer.append(useCn).append(',');
        }
        if (!StrUtil.isEmpty((String)beizhu) && -1 == buffer.toString().indexOf(beizhu)) {
            buffer.append(beizhu).append(',');
        }
        if (-1 != (index = (msg = buffer.toString()).lastIndexOf(","))) {
            msg = msg.substring(0, index);
        }
        return msg;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public String getDeveloper() {
        return "lei luo";
    }

    public String getBizCode() {
        return "b2e0035";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5927\u5ba2\u6237\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3", (String)"DetailImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

