/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.direct.company;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.BizResponse;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.direct.company.DirectCompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DirectCompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return DirectCompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u516c\u5bf9\u516c\u5b9a\u5411\u8d26\u6237\u652f\u4ed8", (String)"DirectCompanyPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        List paymentInfos = request.getPaymentInfos();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
        }
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRootWithHead(token, "b2e0010");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0010-rq");
            if (BankBusinessConfig.isPaymetByAuthorized()) {
                JDomUtils.addChild((Element)trn, (String)"transtype", (String)"1");
            } else {
                JDomUtils.addChild((Element)trn, (String)"transtype", (String)"");
            }
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0010-rq");
                info.setBankRefID(BocNetUtils.getBankDetailSeqId(info));
                JDomUtils.addChild((Element)rq, (String)"insid", (String)BocNetUtils.getInsid(info));
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)BocNetUtils.getSeqIdFromInsid(info.getBankDetailSeqID()));
                Element fractn = JDomUtils.addChild((Element)rq, (String)"fractn");
                JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)info.getAreaCode());
                JDomUtils.addChild((Element)fractn, (String)"actacn", (String)info.getAccNo());
                JDomUtils.addChild((Element)fractn, (String)"actnam", (String)info.getAccName());
                BizResponse directionConfig = BankBusinessConfig.getDirectionAcntConfig(info.getAccNo(), info.getIncomeAccNo());
                String payeeid = directionConfig.getRspCode();
                JDomUtils.addChild((Element)rq, (String)"payeeid", (String)payeeid);
                JDomUtils.addChild((Element)rq, (String)"trnamt", (String)info.getAmount().setScale(2, 4).toString());
                JDomUtils.addChild((Element)rq, (String)"trncur", (String)info.getCurrency());
                JDomUtils.addChild((Element)rq, (String)"priolv", (String)(info.getUrgent() != false ? "1" : "0"));
                JDomUtils.addChild((Element)rq, (String)"furinfo", (String)info.getExplanation());
                JDomUtils.addChild((Element)rq, (String)"trfdate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
                JDomUtils.addChild((Element)rq, (String)"comacn", (String)"");
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos = request.getPaymentInfos());
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0010-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("1011".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0010-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid(insid));
            if (null == info) continue;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

