/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.detail.old;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.banks.pab.dc.services.utils.DetailConstants;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("0");
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = super.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
            this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + 1));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest request) {
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"AcctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Result, (String)"PageNo", (String)this.getCurrentPage());
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "4008", xmlStr);
    }

    private boolean isLastPage(Element root) {
        String endFlag = root.getChildTextTrim("EndFlag");
        String pageRecCount = root.getChildTextTrim("PageRecCount");
        if ("Y".equalsIgnoreCase(endFlag)) {
            return true;
        }
        if ("N".equalsIgnoreCase(endFlag)) {
            return false;
        }
        if (0 == Integer.parseInt(pageRecCount)) {
            return true;
        }
        List list = root.getChildren("list");
        return null == list || list.size() <= 0;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        LinkedList<DetailInfo> details = new LinkedList<DetailInfo>();
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (DetailConstants.NO_RECORDS_CODES.contains(bankRsp.getResponseCode())) {
            log.info("\u8fd4\u56de\u65e0\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u7801:");
            this.setLastPage(true);
            return new EBBankDetailResponse(details);
        }
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25 :%s\u3002", (String)"TodayDetailImpl_9", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            this.setLastPage(true);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        this.setLastPage(this.isLastPage(root));
        String acctNo = root.getChildTextTrim("AcctNo");
        String ccyCode = root.getChildTextTrim("CcyCode");
        String endFlag = root.getChildTextTrim("EndFlag");
        String pageRecCount = root.getChildTextTrim("PageRecCount");
        if (0 == Integer.parseInt(pageRecCount)) {
            return new EBBankDetailResponse(details);
        }
        List list = root.getChildren("list");
        if (null == list || list.size() <= 0) {
            return new EBBankDetailResponse(details);
        }
        for (int i = 0; i < list.size(); ++i) {
            Element listElement = (Element)list.get(i);
            String tranTime1 = listElement.getChildTextTrim("TranTime1");
            String hostSeqNo = listElement.getChildTextTrim("HostSeqNo");
            String hostDate = listElement.getChildTextTrim("HostDate");
            String summonNo = listElement.getChildTextTrim("SummonNo");
            String sendBank = listElement.getChildTextTrim("SendBank");
            String sendAccount = listElement.getChildTextTrim("SendAccount");
            String sendName = listElement.getChildTextTrim("SendName");
            String txAmount = listElement.getChildTextTrim("TxAmount");
            String acctBank = listElement.getChildTextTrim("AcctBank");
            String acctAccount = listElement.getChildTextTrim("AcctAccount");
            String acctName = listElement.getChildTextTrim("AcctName");
            String txType = listElement.getChildTextTrim("TxType");
            String abstractStr = listElement.getChildTextTrim("AbstractStr");
            String notes = listElement.getChildTextTrim("Notes");
            String fee1 = listElement.getChildTextTrim("Fee1");
            String fee2 = listElement.getChildTextTrim("Fee2");
            String abstractStr_Desc = listElement.getChildTextTrim("AbstractStr_Desc");
            String cVoucherNo = listElement.getChildTextTrim("CVoucherNo");
            String cstInnerFlowNo = listElement.getChildTextTrim("CstInnerFlowNo");
            String merge = notes.concat("/" + abstractStr_Desc);
            String tranCode = listElement.getChildTextTrim("TranCode");
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(request.getBankCurrency());
            if (("DIS".equalsIgnoreCase(abstractStr) || "COL".equalsIgnoreCase(abstractStr)) && "X0006".equalsIgnoreCase(tranCode)) {
                detail.setTransType("normal");
            } else if ("DIS".equalsIgnoreCase(abstractStr)) {
                detail.setTransType("autotransdown");
            } else if ("COL".equalsIgnoreCase(abstractStr)) {
                detail.setTransType("autotransup");
            } else {
                detail.setTransType("normal");
            }
            if (notes != null && notes.length() > 11 && notes.startsWith("_KD_")) {
                String bankDetailSeqId = notes.substring("_KD_".length(), "_KD_".length() + 8);
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                notes = notes.substring("_KD_".length() + 8);
            }
            detail.setUseCn(notes);
            if (BankBusinessConfig.isPurposeAsAbstract()) {
                detail.setExplanation(notes);
            } else if (BankBusinessConfig.isMergeAsAbstract()) {
                detail.setExplanation(merge);
            } else {
                detail.setExplanation(abstractStr_Desc);
            }
            detail.setAccNo(request.getAcnt().getAccNo());
            detail.setAccName(request.getAcnt().getAccName());
            detail.setBankName(request.getAcnt().getBankName());
            if ("C".equalsIgnoreCase(txType)) {
                detail.setOppAccNo(sendAccount);
                detail.setOppAccName(sendName);
                detail.setOppBankName(sendBank);
                detail.setCreditAmount(new BigDecimal(txAmount));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("D".equalsIgnoreCase(txType)) {
                detail.setOppAccNo(acctAccount);
                detail.setOppAccName(acctName);
                detail.setOppBankName(acctBank);
                detail.setDebitAmount(new BigDecimal(txAmount));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684TxType[\u501f\u8d37\u6807\u5fd7]\u4e0d\u53ef\u77e5,\u671f\u671b\u503c\u662fC\u6216D.\u5f53\u524d\u8fd4\u56de\u503cTxType=%s", (String)"TodayDetailImpl_10", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), txType));
            }
            if (StringUtils.isEmpty((String)hostDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684'\u4e3b\u673a\u8bb0\u8d26\u65e5\u671f'\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u660e\u7ec6\u7684\u4ea4\u6613\u65f6\u95f4.", (String)"TodayDetailImpl_2", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]));
            }
            try {
                LocalDateTime transDateTime;
                if (!StringUtils.isEmpty((String)tranTime1)) {
                    tranTime1 = StringFormater.formatLen((String)tranTime1, (int)6, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
                    transDateTime = LocalDateTime.parse(hostDate + tranTime1, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    detail.setTransTime(transDateTime);
                    detail.setTransDate(transDateTime.toLocalDate());
                } else {
                    transDateTime = LocalDateTime.parse(hostDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    detail.setTransTime(transDateTime);
                    detail.setTransDate(transDateTime.toLocalDate());
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5f53\u65e5\u660e\u7ec6\u67e5\u8be2\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5f02\u5e38.%s\u3002", (String)"TodayDetailImpl_11", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)hostSeqNo);
            details.add(detail);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"3.14 \u4f01\u4e1a\u5f53\u65e5\u4ea4\u6613\u8be6\u60c5\u67e5\u8be2[4008]", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"TodayDetailImpl_5", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        return false;
    }
}

