/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.financing.redeem;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.InvestmentEnterpriseFinancialQpshuadvqryRequestV1;
import com.icbc.api.response.InvestmentEnterpriseFinancialQpshuadvqryResponseV1;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class QryRedeemFinancingImpl
extends AbstractFinancingImpl
implements IQueryRedeemFinancing {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QryRedeemFinancingImpl.class);

    public EBBankFinancingResponse queryRedeemFinancing(BankFinancingRequest request) {
        List fInfos = request.getInfos();
        if (fInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u7b14\u7406\u8d22\u8d4e\u56de\u3002", (String)"QryRedeemFinancingImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        }
        FinancingInfo fInfo = (FinancingInfo)fInfos.get(0);
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "investment/enterprise/financial/qpshuadvqry/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            InvestmentEnterpriseFinancialQpshuadvqryRequestV1.InvestmentEnterpriseFinancialQpshuadvqryRequestBizV1 bizContent = new InvestmentEnterpriseFinancialQpshuadvqryRequestV1.InvestmentEnterpriseFinancialQpshuadvqryRequestBizV1();
            InvestmentEnterpriseFinancialQpshuadvqryRequestV1 bankRequest = new InvestmentEnterpriseFinancialQpshuadvqryRequestV1();
            bankRequest.setBizContent((BizContent)bizContent);
            bankRequest.setServiceUrl(BASE_URL + URI);
            Date date = new Date();
            bizContent.setTransCode("QPSHUADV");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setfSeqNo(Sequence.genSequence());
            bizContent.setQryFSeqNo(fInfo.getBatchSeqId());
            logger.info("\u7406\u8d22\u4ea7\u54c1\u8d4e\u56de\u6307\u4ee4\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)bankRequest).toString());
            InvestmentEnterpriseFinancialQpshuadvqryResponseV1 response = (InvestmentEnterpriseFinancialQpshuadvqryResponseV1)client.execute((IcbcRequest)bankRequest);
            logger.info("\u7406\u8d22\u4ea7\u54c1\u8d4e\u56de\u6307\u4ee4\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            if (response.isSuccess()) {
                InvestmentEnterpriseFinancialQpshuadvqryResponseV1.InvestmentEnterpriseFinancialQpshuadvqryResponseRdV1 rd = (InvestmentEnterpriseFinancialQpshuadvqryResponseV1.InvestmentEnterpriseFinancialQpshuadvqryResponseRdV1)response.getRd().get(0);
                if (!rd.getiSequenceNo().equalsIgnoreCase(fInfo.getDetailBizNo())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4fe1\u606f\u4e0e\u671f\u671b\u4e0d\u7b26\u3002", (String)"QryRedeemFinancingImpl_1", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
                }
                String result = rd.getResult();
                if (!PackerUtils.staMap.containsKey(result)) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u7ed3\u679c\u7801%s\u3002", (String)"QryRedeemFinancingImpl_4", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), result));
                }
                if ("7".equalsIgnoreCase(result)) {
                    FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.SUCCESS, (String)"", (String)result, (String)rd.getiReturnMsg());
                } else if ("0".equalsIgnoreCase(result) || "1".equalsIgnoreCase(result) || "2".equalsIgnoreCase(result) || "3".equalsIgnoreCase(result) || "4".equalsIgnoreCase(result) || "9".equalsIgnoreCase(result)) {
                    FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.SUBMITED, (String)PackerUtils.staMap.get(result), (String)result, (String)rd.getiReturnMsg());
                } else {
                    FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.FAIL, (String)PackerUtils.staMap.get(result), (String)result, (String)rd.getiReturnMsg());
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        EBBankFinancingResponse ebBankFinancingResponse = new EBBankFinancingResponse();
        ebBankFinancingResponse.setInfos(fInfos);
        return ebBankFinancingResponse;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        return null;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QPSHUADV";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d4e\u56de\u7406\u8d22\u4ea7\u54c1\u67e5\u8be2", (String)"QryRedeemFinancingImpl_3", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return false;
    }
}

