/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.services.payment.samebank;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hfb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hfb.dc.services.login.LoginAccess;
import kd.ebg.aqap.banks.hfb.dc.services.login.LoginAccessManager;
import kd.ebg.aqap.banks.hfb.dc.services.payment.PayParser;
import kd.ebg.aqap.banks.hfb.dc.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.banks.hfb.dc.services.payment.samebank.PayPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger log = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankPayResponse pay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            this.log.info("\u524d\u7f6e\u673a\u4ea4\u4e92\u6d41\u7a0b\u5f00\u59cb");
            String rsqt = PayPacker.packPay(paymentInfos);
            rsqt = rsqt.replaceAll("\n", "");
            rsqt = rsqt.replaceAll("\r", "");
            rsqt = rsqt.replaceAll(" ", "");
            rsqt = "<?xml version=\"1.0\" encoding=\"GBK\"?>" + rsqt;
            this.log.info("\u5c01\u88c5\u6570\u636e\u5b8c\u6210");
            ConnectionFactory factory = this.getConnectionFactory();
            factory.setUri("/HFYQService/APIReqServlet?dse_sessionId=" + token + "&opName=submitStepPayOp");
            factory.setHttpHeader("content-type", "text/xml; charset=GBK");
            this.log.info("\u521b\u5efa\u8fde\u63a5\u5de5\u5382\u5b8c\u6210");
            IConnection conn = this.getConnection(factory);
            this.log.info("\u6784\u9020\u8fde\u63a5\u5b8c\u6210");
            this.openConnection(conn);
            this.log.info("\u6253\u5f00\u8fde\u63a5\u5b8c\u6210");
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rsqt);
                this.log.info("\u53d1\u9001\u6570\u636e\u5b8c\u6210");
                try (InputStream is = this.getInputStream(conn);){
                    this.log.info("\u83b7\u53d6\u8f93\u5165\u6d41\u5b8c\u6210");
                    String rsp = this.recv(is);
                    this.log.info("\u63a5\u6536\u6570\u636e\u5b8c\u6210");
                    PayParser.parsePay(paymentInfos, rsp);
                }
            }
            catch (Throwable t) {
                EBContext.getContext().setThrowableAfterSend(t);
            }
            finally {
                this.log.info("\u89e3\u6790\u5b8c\u6210\uff0c\u524d\u7f6e\u673a\u4ea4\u4e92\u6d41\u7a0b\u7ed3\u675f");
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !UseConvertor.isTransfer((PaymentInfo)paymentInfo) && paymentInfo.is2SameBank() || BankBusinessConfig.isAllocationToCompanyPay() && paymentInfo.is2SameBank();
    }
}

