/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Crypto {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Crypto.class);

    public static String sign(JSONObject data) {
        String s = JSON.toJSONString((Object)JSONObject.parseObject((String)data.toJSONString(), TreeMap.class));
        try {
            byte[] bytes = Base64.getDecoder().decode(Crypto.getPlatformPri());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(privateKey);
            signature.update(s.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static JSONObject verify(String s) {
        JSONObject resp = JSONObject.parseObject((String)s);
        String sign = resp.getString("sign");
        try {
            byte[] bytes = Base64.getDecoder().decode(Crypto.getPlatformPub());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(publicKey);
            signature.update(sign.getBytes(StandardCharsets.UTF_8));
            if (!signature.verify(Base64.getDecoder().decode(sign))) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25", (String)"Crypto_0", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u9a8c\u7b7e\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002", (String)"Crypto_1", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]), (Throwable)e);
        }
        String resp_code = resp.getString("resp_code");
        String resp_desc = resp.getString("resp_desc");
        if (!"00000000".equalsIgnoreCase(resp_code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u54cd\u5e94\u5f02\u5e38,\u8fd4\u56de\u7801%1$s,\u54cd\u5e94\u4fe1\u606f%2$s\u3002", (String)"Crypto_2", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]), resp_code, resp_desc));
        }
        return resp;
    }

    public static String getPlatformPub() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66\u3002", (String)"Crypto_3", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = Crypto.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return Crypto.getKey(fileContent);
    }

    public static String getPlatformPri() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_private_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u5e73\u53f0\u7ea7RSA\u79c1\u94a5\u8bc1\u4e66\u3002", (String)"Crypto_4", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = Crypto.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return Crypto.getKey(fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }
}

