/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.huifu.dc.service.Crypto;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance,
IHisBalance {
    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        ArrayList balanceInfos = new ArrayList(1);
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        while (!startDate.isAfter(endDate)) {
            request.setStartDate(startDate);
            EBBankBalanceResponse resp = this.doBiz(request);
            balanceInfos.addAll(resp.getBalances());
            startDate = startDate.plusDays(1L);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public EBBankBalanceResponse hisBalance(BankBalanceRequest request) {
        return this.balance(request);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject req = new JSONObject();
        req.put("sys_id", (Object)"");
        req.put("product_id", (Object)"");
        JSONObject data = new JSONObject();
        data.put("req_date", (Object)bankBalanceRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        data.put("req_seq_id", (Object)Sequence.gen18Sequence());
        data.put("huifu_id", (Object)RequestContextUtils.getBankParameterValue((String)"hfId"));
        String sign = Crypto.sign(data.clone());
        req.put("data", (Object)data);
        req.put("sign", (Object)sign);
        return req.toJSONString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        JSONObject resp = Crypto.verify(s);
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        JSONArray acctInfo_list = resp.getJSONArray("acctInfo_list");
        boolean exist = false;
        BalanceInfo balanceInfo = new BalanceInfo();
        for (int i = 0; i < acctInfo_list.size(); ++i) {
            JSONObject acctInfo = acctInfo_list.getJSONObject(i);
            String acct_id = acctInfo.getString("acct_id");
            if (!acct_id.equalsIgnoreCase(acnt.getAccNo())) continue;
            exist = true;
            balanceInfo.setBankAcnt(acnt);
            balanceInfo.setCurrentBalance(acctInfo.getBigDecimal("balance_amt"));
            balanceInfo.setAvailableBalance(acctInfo.getBigDecimal("avl_bal"));
            balanceInfo.setBalanceDateTime(bankBalanceRequest.getStartDate().atTime(0, 0, 0));
            balanceInfo.setBankCurrency(bankBalanceRequest.getCurrency());
        }
        if (!exist) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u5f85\u67e5\u8d26\u6237\u53f7\u7684\u4f59\u989d\u4fe1\u606f\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-huifu-dc", (Object[])new Object[0]));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "/v2/trade/acctpayment/balance/query";
    }

    public String getBizCode() {
        return "null";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/v2/trade/acctpayment/balance/query");
    }

    public LocalDate limitDate() {
        return null;
    }

    public boolean async() {
        return false;
    }
}

