/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.util.BankCurrencyMapping;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalancePacker {
    public String packHisBalance(BankBalanceRequest rqst, int pageTag) throws EBServiceException {
        BankAcnt acnt = rqst.getAcnt();
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("NW0100", request_sn);
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACC_NO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"CCYCD", (String)this.getBankCurrency(rqst));
        JDomUtils.addChild((Element)txInfo, (String)"STARTDATE", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"ENDDATE", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"PAGE", (String)String.valueOf(pageTag));
        JDomUtils.addChild((Element)txInfo, (String)"RECORDNUM", (String)String.valueOf(20));
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    private String getBankCurrency(BankBalanceRequest request) {
        return BankCurrencyMapping.getInstance().getNewBankCurrency(request.getBankCurrency());
    }
}

