/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.credit.business.open;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.credit.EBGCreditUtils;
import kd.ebg.aqap.business.credit.openCredit.atomic.AbstractQueryOpenCreditImpl;
import kd.ebg.aqap.business.credit.openCredit.atomic.IQueryOpenCredit;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryOpenCreditImpl
extends AbstractQueryOpenCreditImpl
implements IQueryOpenCredit {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryOpenCreditImpl.class);

    public String pack(BankOpenCreditDetailRequest bankOpenCreditDetailRequest, String s) {
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("NWL901", request_sn);
        OpenCreditDetail detail = (OpenCreditDetail)bankOpenCreditDetailRequest.getDetails().get(0);
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"Ovrlsttn_Trck_No", (String)detail.getBankBatchSeqId());
        JDomUtils.addChild((Element)txInfo, (String)"LglPsn_BIO_Mode_Cd", (String)"C");
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public List<OpenCreditDetail> parse(BankOpenCreditDetailRequest request, String responseStr) {
        return null;
    }

    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "NWL901";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56fd\u7ed3\u4e1a\u52a1\u7ed3\u679c\u67e5\u8be2", (String)"QueryOpenCreditImpl_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(OpenCreditDetail openCreditDetail) {
        return true;
    }

    public boolean isParserAuto() {
        return true;
    }

    public String getStructIdPacker() {
        return "creditQuery";
    }

    public List<OpenCreditDetail> parserUtil(BankOpenCreditDetailRequest request, String responStr) {
        Element root = CCB_DC_Parser.parseString2Root(responStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankResponse)response, (String)"000000");
        Element txInfo = root.getChild("TX_INFO");
        String Txn_Cntnt = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"Txn_Cntnt");
        JSONObject object = JSONObject.parseObject((String)Txn_Cntnt);
        String Result = object.getString("Result");
        if ("01".equals(Result)) {
            if (StringUtils.isEmpty((String)((OpenCreditDetail)request.getDetails().get(0)).getCreditNo())) {
                String lCNO = object.getString("LCNO");
                ((OpenCreditDetail)request.getDetails().get(0)).setCreditNo(lCNO);
            }
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.SUCCESS, (String)response.getResponseCode(), (String)"");
        } else if ("02".equals(Result)) {
            String Reason = object.getString("Reason");
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)Reason);
        } else if ("03".equals(Result)) {
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)"");
        } else {
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return request.getDetails();
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }
}

