/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.CCB_DCFileUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay6W1301(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element header = CCB_DC_Packer.createTransactionHeader("6W1301", paymentInfos[0].getBankBatchSeqId());
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACCNO", (String)paymentInfos[0].getAccNo());
        String billCode = BankBusinessConfig.getInnerSalaryBillCode(paymentInfos[0].getAccNo());
        if (StringUtils.isEmpty((String)billCode) && !EBContext.getContext().isUnitTest()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u53d1\u4e1a\u52a1\u7684'\u4ee3\u53d1\u7f16\u53f7'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\"\u67e5\u8be2\u4e0e\u652f\u4ed8\"\u7684\u94f6\u4f01\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u8d26\u53f7[%s]\u7684'\u5168\u56fd/\u8de8\u884c\u4ee3\u53d1BillCode'\u3002", (String)"PayPacker_7", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), paymentInfos[0].getAccNo()));
        }
        JDomUtils.addChild((Element)txInfo, (String)"BILL_CODE", (String)billCode);
        JDomUtils.addChild((Element)txInfo, (String)"USEOF_CODE", (String)BankBusinessConfig.getSalaryUseofCode(paymentInfos[0].getAccNo()));
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        CCB_DCFileUtil fileUtil = new CCB_DCFileUtil();
        String fileName = paymentInfos[0].getBankBatchSeqId() + ".txt";
        String fileContent = fileUtil.packUploadFileContentStr(paymentInfos);
        if (StringUtils.isEmpty((String)fileContent)) {
            return "";
        }
        String absoluteFileName = fileUtil.uploadFile(fileName, fileContent);
        Element header = CCB_DC_Packer.createTransactionHeader("6W2102", String.valueOf(Sequence.gen16NumSequence()));
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"SEND_FILE", (String)absoluteFileName);
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public String packPay6W2100(PaymentInfo[] paymentInfos, String rspStr6W2102) throws EBServiceException {
        String billCode = "";
        billCode = paymentInfos[0].is2SameBank() ? BankBusinessConfig.getInnerSalaryBillCode(paymentInfos[0].getAccNo()) : BankBusinessConfig.getOutterSalaryBillCode(paymentInfos[0].getAccNo());
        if (StringUtils.isEmpty((String)billCode) && !EBContext.getContext().isUnitTest()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u53d1\u4e1a\u52a1\u7684'\u4ee3\u53d1\u7f16\u53f7'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\"\u67e5\u8be2\u4e0e\u652f\u4ed8\"\u7684\u94f6\u4f01\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u8d26\u53f7[%s]\u7684'\u5168\u56fd/\u8de8\u884c\u4ee3\u53d1BillCode'\u3002", (String)"PayPacker_7", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), paymentInfos[0].getAccNo()));
        }
        Element rspRoot = CCB_DC_Parser.parseString2Root(rspStr6W2102);
        Element rspBody = JDomUtils.getChildElementNotNull((Element)rspRoot, (String)"TX_INFO");
        String sendFile = JDomUtils.getChildTextNotNull((Element)rspBody, (String)"SEND_FILE");
        String oriFile = JDomUtils.getChildTextNotNull((Element)rspBody, (String)"ORI_FILE");
        Element header = CCB_DC_Packer.createTransactionHeader("6W2100", paymentInfos[0].getBankBatchSeqId());
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"BILL_CODE", (String)billCode);
        JDomUtils.addChild((Element)txInfo, (String)"BILLDESC", (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"PayPacker_2", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)txInfo, (String)"BILL_FLAG", (String)"0");
        JDomUtils.addChild((Element)txInfo, (String)"USEOF_CODE", (String)BankBusinessConfig.getSalaryUseofCode(paymentInfos[0].getAccNo()));
        JDomUtils.addChild((Element)txInfo, (String)"USE", (String)CCB_DC_Packer.getExplain(paymentInfos[0]));
        JDomUtils.addChild((Element)txInfo, (String)"USEOF", (String)CCB_DC_Packer.getExplain(paymentInfos[0]));
        JDomUtils.addChild((Element)txInfo, (String)"SEND_FILE", (String)sendFile);
        JDomUtils.addChild((Element)txInfo, (String)"ORI_FILE", (String)oriFile);
        JDomUtils.addChild((Element)txInfo, (String)"ACC_NO", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"AMOUNT", (String)this.getAmountStr(paymentInfos));
        JDomUtils.addChild((Element)txInfo, (String)"COUNT", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)txInfo, (String)"FLOW_FLAG", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"ASYN_FLAG", (String)"");
        JDomUtils.addChild((Element)header, (Element)txInfo);
        JDomUtils.addChild((Element)header, (String)"SIGN_INFO", (String)"");
        JDomUtils.addChild((Element)header, (String)"SIGNCERT", (String)"");
        return JDomUtils.root2String((Element)header, (String)EBContext.getContext().getCharsetName());
    }

    public String getAmountStr(PaymentInfo[] paymentInfos) {
        BigDecimal amount = new BigDecimal(0);
        for (PaymentInfo paymentInfo : paymentInfos) {
            amount = amount.add(paymentInfo.getAmount());
        }
        return amount.toString();
    }
}

