/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.income;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5efa\u884c\u5916\u8054\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613\u4e1a\u52a1\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"PayPacker_4", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
        Element header = CCB_DC_Packer.createTransactionHeader("6W1303", paymentInfos[0].getBankBatchSeqId());
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACC_NO1", (String)paymentInfos[0].getAccNo());
        String billCode = BankBusinessConfig.getIncomeBillCode(paymentInfos[0].getAccNo());
        if (StringUtils.isEmpty((String)billCode) && !EBContext.getContext().isUnitTest()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u6263\u4e1a\u52a1\u7684'\u4ee3\u6263\u7f16\u53f7'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\"\u67e5\u8be2\u4e0e\u652f\u4ed8\"\u7684\u94f6\u4f01\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u8d26\u53f7[%s]\u7684'\u4ee3\u6263\u7f16\u53f7'\u3002", (String)"PayPacker_8", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), paymentInfos[0].getAccNo()));
        }
        JDomUtils.addChild((Element)txInfo, (String)"BILL_CODE", (String)billCode);
        JDomUtils.addChild((Element)txInfo, (String)"ACC_NO2", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"OTHER_NAME", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)txInfo, (String)"AMOUNT", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)txInfo, (String)"USEOF_CODE", (String)BankBusinessConfig.getIncomeUseofCode(paymentInfos[0].getAccNo()));
        JDomUtils.addChild((Element)txInfo, (String)"FLOW_FLAG", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"UBANK_NO", (String)paymentInfos[0].getIncomeCnaps());
        String exp = CCB_DC_Packer.getExplain(paymentInfos[0]);
        JDomUtils.addChild((Element)txInfo, (String)"USEOF", (String)exp);
        JDomUtils.addChild((Element)txInfo, (String)"REM1", (String)exp);
        JDomUtils.addChild((Element)txInfo, (String)"REM2");
        JDomUtils.addChild((Element)header, (Element)txInfo);
        JDomUtils.addChild((Element)header, (String)"SIGN_INFO", (String)"");
        JDomUtils.addChild((Element)header, (String)"SIGNCERT", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)header, (String)encoding);
    }
}

