/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bcs.dc.service.proxy.FileDownLoadUtil;
import kd.ebg.aqap.banks.bcs.dc.util.Common;
import kd.ebg.aqap.banks.bcs.dc.util.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200110";
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String TEST_DATE = RequestContextUtils.getParameter().getBankParameter("TESTDATE");
        if (StringUtils.isNotEmpty((String)TEST_DATE)) {
            JDomUtils.addChild((Element)body, (String)"start_date", (String)TEST_DATE);
            JDomUtils.addChild((Element)body, (String)"end_date", (String)TEST_DATE);
        } else {
            JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        FileDownLoadUtil fileUtil = new FileDownLoadUtil();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        rspStr = Common.parseRecvMsg(rspStr);
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            this.log.error("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return new EBBankDetailResponse(details);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equals(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = fileUtil.doBiz(file_name);
                this.log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6', \u660e\u7ec6\u5185\u5bb9\uff1a" + content);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            content = body.getChildTextTrim("serial_record");
        }
        String[][] r2 = this.parseRecord(content, recordNum, fieldNum);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int k = 0; k < r2.length; ++k) {
            String[] r2_k = r2[k];
            DetailInfo detailInfo = this.parseR2(r2_k, request, countMap);
            if (detailInfo == null) continue;
            details.add(detailInfo);
        }
        this.log.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return new EBBankDetailResponse(details);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DetailInfo parseR2(String[] r2_k, BankDetailRequest req, Map<String, Integer> countMap) {
        String payamt;
        String rcvamt;
        String acno = r2_k[1];
        String tr_currency = r2_k[2];
        String tr_acdt = r2_k[3];
        String tr_time = r2_k[4];
        String tranDate = tr_acdt + tr_time;
        String host_serial_no = r2_k[5];
        String acname = r2_k[7];
        String opp_acno = r2_k[8];
        String opp_acname = r2_k[10];
        String oppBank = r2_k[11];
        String crdr_flag = r2_k[23];
        String amt = r2_k[24];
        String balance = r2_k[25];
        String summary = r2_k[34];
        String summary2 = r2_k[35];
        if (r2_k.length > 42) {
            rcvamt = r2_k[44];
            payamt = r2_k[43];
        } else {
            payamt = r2_k[40];
            rcvamt = r2_k[41];
        }
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setBankName(req.getAcnt().getBankName());
        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setOppBankName(oppBank);
        detailInfo.setCurrency(tr_currency);
        try {
            detailInfo.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detailInfo.setTransTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        }
        catch (Exception e) {
            this.log.error("\u4ea4\u6613\u65e5\u671f/\u65f6\u95f4\u89e3\u6790\u62a5\u9519", (Throwable)e);
            return null;
        }
        if ("D".equalsIgnoreCase(crdr_flag)) {
            if (!StringUtils.isNotEmpty((String)payamt)) {
                this.log.error("\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff0c\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a");
                return null;
            }
            detailInfo.setDebitAmount(new BigDecimal(payamt));
            detailInfo.setCreditAmount(new BigDecimal("0.00"));
        } else {
            if (!"C".equalsIgnoreCase(crdr_flag)) {
                this.log.warn("\u501f\u8d37\u6807\u5fd7crdr_flag\u8fd4\u56de\u975e\u6b63\u5e38\u503c\uff1a{}", new Object[]{crdr_flag});
                return null;
            }
            if (!StringUtils.isNotEmpty((String)rcvamt)) {
                this.log.error("\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff0c\u6536\u6b3e\u91d1\u989d\u4e3a\u7a7a");
                return null;
            }
            detailInfo.setDebitAmount(new BigDecimal("0.00"));
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }
        detailInfo.setExplanation(summary);
        if (BankBusinessConfig.isPostscript2Exp()) {
            detailInfo.setExplanation(summary2);
        }
        if (StringUtils.isNotEmpty((String)balance)) {
            detailInfo.setBalance(new BigDecimal(balance));
        }
        detailInfo.setBankDetailNo(host_serial_no);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("TR_ACDT", (Object)tr_acdt);
        jsonObject.put("HOST_SERIAL_NO", (Object)host_serial_no);
        jsonObject.put("cdFlag", (Object)crdr_flag);
        jsonObject.put("Amount", (Object)amt);
        jsonObject.put("summary", (Object)summary);
        jsonObject.put("postscript", (Object)summary2);
        detailInfo.setJsonMap(jsonObject.toJSONString());
        String transferDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
        String receiptNo = MatchRule.getInstance().getReceiptNo(acno, transferDate, jsonObject.toJSONString());
        if (countMap.containsKey(receiptNo)) {
            int count = countMap.get(receiptNo) + 1;
            countMap.put(receiptNo, count);
            receiptNo = receiptNo + "-" + String.format("%04d", count);
        } else {
            countMap.put(receiptNo, 0);
        }
        detailInfo.setReceiptNo(receiptNo);
        return detailInfo;
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]);
    }
}

