/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.simulator.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.ebg.aqap.banks.simulator.utils.QueryUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SimDetail
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(8);
        String accNo = request.getAcnt().getAccNo();
        QFilter qFilter = QFilter.of((String)"status_id = ? and insert_time < ? and insert_time > ? and bank_version_id = ?", (Object[])new Object[]{PaymentState.SUCCESS.getId(), request.getEndDate().plusDays(1L).atTime(0, 0), request.getStartDate().atTime(0, 0), "EBG_SIM"});
        List infos = QueryUtil.queryPayments(qFilter).stream().filter(e -> e.getAccNo().equalsIgnoreCase(accNo) || e.getIncomeAccNo().equalsIgnoreCase(accNo)).collect(Collectors.toList());
        for (PaymentInfo p : infos) {
            String bal;
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setCurrency(request.getBankCurrency());
            BigDecimal amount = p.getAmount();
            if (p.getAccNo().equalsIgnoreCase(accNo)) {
                detailInfo.setDebitAmount(amount);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
                detailInfo.setOppAccNo(p.getIncomeAccNo());
                detailInfo.setOppAccName(p.getIncomeAccName());
                detailInfo.setOppBankName(p.getIncomeBankName());
                detailInfo.setPayBankDetailSeqID(p.getBankDetailSeqID());
                bal = PaymentInfoSysFiled.get((PaymentInfo)p, (String)"bal");
                if (StringUtils.isNotEmpty((String)bal)) {
                    detailInfo.setBalance(new BigDecimal(bal));
                }
            } else {
                detailInfo.setCreditAmount(amount);
                detailInfo.setDebitAmount(BigDecimal.ZERO);
                detailInfo.setOppAccNo(p.getAccNo());
                detailInfo.setOppAccName(p.getAccName());
                detailInfo.setOppBankName(p.getBankName());
                bal = PaymentInfoSysFiled.get((PaymentInfo)p, (String)"payeeBal");
                if (StringUtils.isNotEmpty((String)bal)) {
                    detailInfo.setBalance(new BigDecimal(bal));
                }
            }
            detailInfo.setExplanation(p.getExplanation());
            detailInfo.setTransDate(p.getInsertTime().toLocalDate());
            detailInfo.setTransTime(p.getInsertTime());
            detailInfo.setReceiptNo(p.getBankDetailSeqID());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uniID", (Object)p.getDetailBizNo());
            detailInfo.setJsonMap(jsonObject.toJSONString());
            result.add(detailInfo);
        }
        return new EBBankDetailResponse(result);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

