/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;

public class RequestContextUtils {
    public static EBContext getRequestContext() {
        EBContext context = EBContext.getContext();
        if (Objects.isNull(context)) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef context (in RequestContextUtils)", (String)"RequestContextUtils_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        return context;
    }

    public static IParameter getParameter() {
        IParameter parameter = RequestContextUtils.getRequestContext().getParameter();
        if (null != parameter) {
            return parameter;
        }
        throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef !Parameter\u4e0d\u5b58\u5728!(in RequestContextUtils)", (String)"RequestContextUtils_1", (String)"ebg-egf-common", (Object[])new Object[0]));
    }

    public static String getBankParameterValue(String bankConfigId) {
        IParameter parameter = RequestContextUtils.getParameter();
        String value = parameter.getBankParameter(bankConfigId);
        return value;
    }

    public static String getCharset() {
        return RequestContextUtils.getBankParameterValue("charset");
    }

    public static String getCustomId() {
        return RequestContextUtils.getRequestContext().getCustomID();
    }

    public static String getExchangeProtocol() {
        return RequestContextUtils.getBankParameterValue("exchangeProtocol");
    }

    public static int getExchangePort() {
        String exchangePortStr = RequestContextUtils.getBankParameterValue("exchangePort");
        if (null != exchangePortStr) {
            try {
                int exchangePort = Integer.parseInt(exchangePortStr);
                return exchangePort;
            }
            catch (NumberFormatException e) {
                throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u975e\u6cd5,\u8bbe\u7f6e\u7684\u4ea4\u6613\u7aef\u53e3\u662f%s", (String)"RequestContextUtils_2", (String)"ebg-egf-common", (Object[])new Object[0]), exchangePortStr));
            }
        }
        throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u7a0b\u5e8f\u9519\u8bef !Parameter\u4e2dexchangePort\u4e0d\u5b58\u5728!", (String)"RequestContextUtils_3", (String)"ebg-egf-common", (Object[])new Object[0]));
    }

    public static void setRunningParam(String key, String value) {
        EBContext context = RequestContextUtils.getRequestContext();
        Map<String, String> runningParams = context.getRunningParams();
        if (Objects.isNull(runningParams)) {
            runningParams = new HashMap<String, String>(16);
            context.setRunningParams(runningParams);
        }
        runningParams.put(key, value);
    }

    public static String getRunningParam(String key) {
        EBContext context = RequestContextUtils.getRequestContext();
        Map<String, String> runningParams = context.getRunningParams();
        if (Objects.isNull(runningParams)) {
            return null;
        }
        return runningParams.get(key);
    }
}

