/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.FilterConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.XMLFormat;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.LogFilterUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LoggerConnection
extends FilterConnection {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(LoggerConnection.class);
    private static final String BANK_MESSAGE_LOG = "aqap_message.";
    private static String requestSeqID;

    public LoggerConnection(IConnection connection) {
        super(connection);
    }

    @Override
    public void openConnection() throws IOException {
        this.connection.openConnection();
    }

    @Override
    public void closeConnection() {
        this.connection.closeConnection();
    }

    @Override
    public void beforeRead(InputStream inputStream) {
        LoggerConnection.writeLog("", ResManager.loadKDString((String)"\u51c6\u5907\u8bfb\u53d6\u6570\u636e", (String)"LoggerConnection_0", (String)"ebg-egf-common", (Object[])new Object[0]));
    }

    @Override
    public void afterRead(InputStream inputStream, byte[] bytes) {
        int n = bytes.length;
        if (n <= 0) {
            LoggerConnection.writeLog("", ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u8bfb\u3002", (String)"LoggerConnection_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        } else {
            LoggerConnection.writeLog("", String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u4e86%s\u5b57\u8282\u3002", (String)"LoggerConnection_2", (String)"ebg-egf-common", (Object[])new Object[0]), n));
        }
    }

    @Override
    public void beforeWrite(OutputStream outputStream, byte[] bytes) {
        LoggerConnection.writeLog("", ResManager.loadKDString((String)"\u83b7\u53d6\u8f93\u51fa\u6d41\u6210\u529f\uff0c\u51c6\u5907\u53d1\u9001\u6570\u636e\u3002", (String)"LoggerConnection_4", (String)"ebg-egf-common", (Object[])new Object[0]));
    }

    @Override
    public void afterWrite(OutputStream outputStream, byte[] bytes) {
        int n = bytes.length;
        if (n <= 0) {
            LoggerConnection.writeLog("", ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u53ef\u53d1\u9001\u4e86", (String)"LoggerConnection_5", (String)"ebg-egf-common", (Object[])new Object[0]));
        } else {
            String charsetName = this.getCharset();
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)charsetName) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u672a\u6307\u5b9a\u5b57\u7b26\u96c6\u3002", (String)"LoggerConnection_3", (String)"ebg-egf-common", (Object[])new Object[0]));
            Charset charset = Charset.forName(charsetName);
            String str = new String(bytes, charset);
            LoggerConnection.writeLog("request", XMLFormat.formatXml(str, charset));
            LoggerConnection.writeLog("", String.format(ResManager.loadKDString((String)"\u5df2\u53d1\u9001 %s \u5b57\u8282\u7684\u6570\u636e\u3002", (String)"LoggerConnection_6", (String)"ebg-egf-common", (Object[])new Object[0]), n));
        }
    }

    private String getCharset() {
        if (this.connection instanceof SSLConnection) {
            return "UTF-8";
        }
        return EBContext.getContext().getCharsetName();
    }

    public static void writeLogger(String type, String message) {
        if (StringUtils.isEmpty(EBContext.getContext().getLogBizSeqID())) {
            EBContext.getContext().setLogBizSeqID(Sequence.gen18Sequence());
        }
        EBContext.getContext().setType(type);
        if ("request".equals(type)) {
            logger.infoPrivacy(message);
        } else {
            logger.infoFilerLog(message);
        }
    }

    public static void writeLogger(String type, String title, String content) {
        StringBuilder sb = new StringBuilder();
        if ("request".equalsIgnoreCase(type) || "response".equalsIgnoreCase(type)) {
            content = LogFilterUtil.getSendResult(content);
        }
        sb.append(title).append(content);
        logger.info(sb.toString());
    }

    private static void writeLog(String type, String message) {
        if (StringUtils.isNotEmpty(type)) {
            LoggerConnection.writeLogger(type, message);
        }
    }
}

