/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static void sendFully(OutputStream outputStream, String str) {
        IOUtils.write(str, outputStream, IOUtils.getCharsetName());
    }

    public static void sendFully(OutputStream outputStream, String str, String charsetName) {
        IOUtils.write(str, outputStream, charsetName);
    }

    public static void sendFully(OutputStream outputStream) {
        IOUtils.writeDataIsEmpty(outputStream);
    }

    public static String readFully(InputStream inputStream, String charsetName) {
        Preconditions.checkNotNull((Object)inputStream, (Object)ResManager.loadKDString((String)"\u8f93\u5165\u6d41\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IOUtils_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull((Object)charsetName, (Object)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IOUtils_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6%s", (String)"IOUtils_2", (String)"ebg-egf-common", (Object[])new Object[0]), charsetName), e);
        }
        try {
            IOUtils.copy(inputStreamReader, stringWriter);
            String e = stringWriter.toString();
            return e;
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8bfb\u53d6\u6570\u636e\u5f02\u5e38", (String)"IOUtils_3", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                logger.info("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static String readFully(InputStream inputStream) {
        return IOUtils.readFully(inputStream, IOUtils.getCharsetName());
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long count = IOUtils.copyLarge(inputStream, outputStream);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeOutputStreamQuietly(OutputStream outputStream) {
    }

    public static void closeInputStreamQuietly(InputStream inputStream) {
        if (Objects.nonNull(inputStream)) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.info("\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void write(byte[] data, OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull((Object)data, (Object)ResManager.loadKDString((String)"\u8981\u53d1\u9001\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IOUtils_4", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull((Object)outputStream, (Object)ResManager.loadKDString((String)"\u8f93\u51fa\u6d41\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IOUtils_5", (String)"ebg-egf-common", (Object[])new Object[0]));
        outputStream.write(data);
    }

    private static void write(String data, OutputStream outputStream, String charsetName) {
        if (Strings.isNullOrEmpty((String)data)) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8981\u53d1\u9001\u7684\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"IOUtils_6", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        try {
            outputStream.write(data.getBytes(charsetName));
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"IO \u5f02\u5e38\uff0c\u53d1\u9001\u6570\u636e\u5931\u8d25\u3002", (String)"IOUtils_7", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    private static void writeDataIsEmpty(OutputStream outputStream) {
        try {
            outputStream.write("".getBytes(IOUtils.getCharsetName()));
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"IO \u5f02\u5e38\uff0c\u53d1\u9001\u6570\u636e\u5931\u8d25\u3002", (String)"IOUtils_7", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    public static String getCharsetName() {
        String charsetName = EBContext.getContext().getCharsetName();
        if (Strings.isNullOrEmpty((String)charsetName)) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u672a\u6307\u5b9a\u5b57\u7b26\u96c6\u3002", (String)"IOUtils_8", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        return charsetName;
    }

    public static Integer getConnectionTimeout() {
        try {
            ObjectPropertyService propertyService = ObjectPropertyService.getInstance();
            ObjectPropertiesKey key = new ObjectPropertiesKey();
            key.setAttrKey("CONNECT_WAIT_TIMEOUT");
            key.setObjectID("common_business");
            key.setObjectName("ebg");
            String timeout = propertyService.getPropertyValue(key);
            if (StringUtils.isEmpty(timeout)) {
                return 2000;
            }
            return Integer.parseInt(timeout) * 1000;
        }
        catch (Exception ignore) {
            return 2000;
        }
    }
}

