/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.lock;

import java.util.concurrent.Semaphore;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFEPAccess
implements FEPAccess {
    private static final Logger logger = LoggerFactory.getLogger(LocalFEPAccess.class);
    private String key;
    private int concurrencyCount;
    private Semaphore semaphore;

    public LocalFEPAccess(String key, int concurrencyCount) {
        this.key = key;
        this.concurrencyCount = concurrencyCount > 0 ? concurrencyCount : 1;
        this.semaphore = new Semaphore(this.concurrencyCount);
    }

    @Override
    public void release() {
        if (this.semaphore.availablePermits() < this.concurrencyCount) {
            this.semaphore.release();
        }
        logger.info("\u91ca\u653e\u524d\u7f6e\u673a\u9501\u6210\u529f");
    }

    @Override
    public void lock() {
        logger.info("\u5c1d\u8bd5\u83b7\u53d6\u524d\u7f6e\u673a\u9501");
        try {
            this.semaphore.acquire();
            logger.info("\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u6210\u529f");
        }
        catch (InterruptedException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u7684\u65f6\u5019\u4e2d\u65ad\u5f02\u5e38", (String)"LocalFEPAccess_0", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    @Override
    public void lock(int time) {
        logger.info("\u5c1d\u8bd5\u83b7\u53d6\u524d\u7f6e\u673a\u9501");
        try {
            this.semaphore.acquire(time);
            logger.info("\u83b7\u53d6\u524d\u7f6e\u673a\u9501\u6210\u529f");
        }
        catch (InterruptedException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u7684\u65f6\u5019\u4e2d\u65ad\u5f02\u5e38", (String)"LocalFEPAccess_0", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }
}

