/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security;

import kd.bos.util.StringUtils;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import kd.ebg.egf.common.framework.security.atomic.ISignature;
import kd.ebg.egf.common.framework.security.factory.EBSecurityFactory;

public class EBSecuritySuit
implements IEncrypt,
ISignature {
    private byte[] encryptKey;
    private byte[] kdPrivateKey;
    private byte[] customPublicKey;
    private static final String encryptAlgorithm = "";
    private String signAlgorithm;
    private IEncrypt EBEncrypt;
    private ISignature EBSignature;

    private void initEncrypt() {
        if (null == this.EBEncrypt) {
            this.EBEncrypt = EBSecurityFactory.INSTANCE.getEBEncrypt(encryptAlgorithm, this.encryptKey);
        }
    }

    private void initSign() {
        if (null == this.EBSignature) {
            this.EBSignature = EBSecurityFactory.INSTANCE.getEBSignature(this.signAlgorithm, this.kdPrivateKey, this.customPublicKey);
        }
    }

    public EBSecuritySuit(byte[] customPublicKey, byte[] kdPrivateKey, String signAlgorithm) {
        this.customPublicKey = customPublicKey;
        this.kdPrivateKey = kdPrivateKey;
        this.signAlgorithm = signAlgorithm;
    }

    public EBSecuritySuit(String signAlgorithm, byte[] encryptKey) {
        this.signAlgorithm = signAlgorithm;
        this.encryptKey = encryptKey;
    }

    @Override
    public String encrypt(byte[] source) {
        this.initEncrypt();
        return this.EBEncrypt.encrypt(source);
    }

    @Override
    public byte[] decrypt(String source) {
        this.initEncrypt();
        return this.EBEncrypt.decrypt(source);
    }

    @Override
    public String sign(byte[] source) {
        this.initSign();
        return this.EBSignature.sign(source);
    }

    @Override
    public boolean verify(String sign, byte[] content) {
        if (StringUtils.isEmpty((String)sign)) {
            return false;
        }
        this.initSign();
        return this.EBSignature.verify(sign, content);
    }
}

