/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.factory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import kd.ebg.egf.common.framework.security.api.ICustomerEncryptKeyStorage;

public enum DefaultEBCustomerEncryptKeyStorage implements ICustomerEncryptKeyStorage
{
    INSTANCE;

    private static Cache<String, byte[]> encryptKeyCache;

    @Override
    public void storeDecryptKey(String md5, byte[] key) {
        encryptKeyCache.put((Object)md5, (Object)key);
    }

    @Override
    public byte[] getDecryptKey(String md5) {
        return (byte[])encryptKeyCache.getIfPresent((Object)md5);
    }

    static {
        encryptKeyCache = CacheBuilder.newBuilder().initialCapacity(100000).expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(10L).recordStats().build();
    }
}

