/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.provider;

import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.framework.security.api.ICustomerEncryptKeyStorage;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CachedCustomerEncryptKeyStorage
implements ICustomerEncryptKeyStorage {
    private static CachedCustomerEncryptKeyStorage instance = new CachedCustomerEncryptKeyStorage();

    public static ICustomerEncryptKeyStorage getInstance() {
        return instance;
    }

    @Override
    public void storeDecryptKey(String token, byte[] key) {
        String value = new String(key);
        CosmicCache.putIfAbsent("eb_encryptCache_" + token, value);
    }

    @Override
    public byte[] getDecryptKey(String token) {
        String value = CosmicCache.get("eb_encryptCache_" + token);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return value.getBytes();
    }
}

