/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class P12CertReader {
    private KeyStore keyStore;
    private String certPath;
    private String certPwd;
    private String alias;
    private InputStream stream;
    private static final String KEY_STORE_TYPE = "PKCS12";

    public P12CertReader(String certPath, String certPwd, String alias) {
        this.certPath = certPath;
        this.certPwd = certPwd;
        this.alias = alias;
    }

    public P12CertReader(InputStream stream, String certPwd, String alias) {
        this.stream = stream;
        this.certPwd = certPwd;
        this.alias = alias;
    }

    public PrivateKey getPrivateKey() throws Exception {
        return (PrivateKey)this.keyStore.getKey(this.getAlias(), this.certPwd.toCharArray());
    }

    public PublicKey getPublicKey() throws Exception {
        return this.getCertificate().getPublicKey();
    }

    public String getAlias() throws Exception {
        if (null != this.alias && !"".equalsIgnoreCase(this.alias)) {
            return this.alias;
        }
        Enumeration<String> aliases = this.keyStore.aliases();
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        return null;
    }

    public void initKeyStore() throws Exception {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        if (null == this.stream) {
            this.stream = new FileInputStream(new File(this.certPath));
        }
        this.keyStore.load(this.stream, this.certPwd.toCharArray());
        this.stream.close();
    }

    public Certificate getCertificate() throws Exception {
        return this.keyStore.getCertificate(this.getAlias());
    }
}

