/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.framework.lock.LeaseEnum;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKVN;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRelRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankLoginConfigService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankLoginConfigService.class);
    private static BankLoginConfigService instance = new BankLoginConfigService();
    private BankLoginConfigRepository configRepository = BankLoginConfigRepository.getInstance();
    private BankLoginRelRepository bankLoginRelRepository = BankLoginRelRepository.getInstance();

    public static BankLoginConfigService getInstance() {
        return instance;
    }

    public int getMaxLeaseNum(String bankLogin, LeaseEnum leaseEnum) {
        int leaseNum = 1;
        String bankConfigID = leaseEnum.getName();
        String customID = RequestContext.get().getTenantId();
        DynamicObject dynamicObject = this.configRepository.loadByBankLoginIDAndCustomIDAndBankConfigID(bankLogin, customID, bankConfigID);
        if (dynamicObject != null) {
            String value = dynamicObject.getString("bank_config_value");
            leaseNum = Integer.parseInt(value);
        }
        return leaseNum;
    }

    public String getBankLoginRelPayExclusiveNumber(String masterNumber) {
        DynamicObject dynamicObject = this.bankLoginRelRepository.findByMasterNumberAndConfigType(masterNumber, CosmicConstants.BANK_LOGIN_REL_CONFIG_TYPE_PAY);
        if (dynamicObject != null) {
            return dynamicObject.getString("exclusive_number");
        }
        return "";
    }

    public String getBankLoginRelPayExclusiveNumberAndConfigType(String masterNumber, String configType) {
        if (StringUtils.isEmpty(configType)) {
            return "";
        }
        DynamicObject dynamicObject = this.bankLoginRelRepository.findByMasterNumberAndConfigType(masterNumber, configType);
        if (dynamicObject != null) {
            return dynamicObject.getString("exclusive_number");
        }
        return "";
    }

    public String getBankLoginConfigValue(BankLoginConfigKey key) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankLoginConfigService_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        return Optional.ofNullable(this.configRepository.findById(key)).map(BankLoginConfig::getBankConfigValue).orElse(null);
    }

    public BankLoginConfig getBankLoginConfig(BankLoginConfigKey key) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankLoginConfigService_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        return this.configRepository.findById(key);
    }

    public boolean isSupportTodayReceipt(String bankLoginID, String customId) {
        DynamicObject result = this.configRepository.findByBankLoginIDAndCustomIDAndBankConfigID(bankLoginID, customId, "is_support_today_receipt");
        if (result == null) {
            return false;
        }
        return "true".equals(result.getString("bank_config_value"));
    }

    public void setBankLoginConfigValue(BankLoginConfigKey key, String bankConfigValue) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankLoginConfigService_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        BankLoginConfig bankLoginConfig = this.configRepository.findById(key);
        if (bankLoginConfig == null) {
            bankLoginConfig = new BankLoginConfig();
            bankLoginConfig.setKey(key);
            bankLoginConfig.setInputType("text");
            bankLoginConfig.setBankConfigName(key.getBankConfigId());
            bankLoginConfig.setBankConfigValue(bankConfigValue);
            bankLoginConfig.setReadOnly(true);
        }
        bankLoginConfig.setBankConfigValue(bankConfigValue);
        this.configRepository.save(bankLoginConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection(String ip, int port) {
        Socket socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(ip, port);
        try {
            socket.connect(inetSocketAddress, 3000);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<BankLoginConfigKVN> getBankLoginConfigKVNList(String bankLoginID, String customID) {
        ArrayList<BankLoginConfigKVN> result = new ArrayList<BankLoginConfigKVN>(1);
        DynamicObjectCollection collections = this.configRepository.findByBankLoginIDAndCustomID(bankLoginID, customID);
        if (collections != null && collections.size() > 0) {
            collections.stream().forEach(dynamicObject -> {
                BankLoginConfigKVN bankLoginConfigKVN = new BankLoginConfigKVN();
                bankLoginConfigKVN.setBankConfigID(dynamicObject.getString("bank_config_id"));
                bankLoginConfigKVN.setBankConfigName(dynamicObject.getString("name"));
                bankLoginConfigKVN.setBankConfigValue(dynamicObject.getString("bank_config_value"));
                result.add(bankLoginConfigKVN);
            });
        }
        return result;
    }

    public boolean save(List<BankLoginConfig> bankLoginConfigs, String bankVersionID, String bankVersionName, String customID) {
        int maxVersion = this.getMaxVersionValue(bankVersionID);
        return this.save(bankLoginConfigs, bankVersionID, bankVersionName, maxVersion, customID);
    }

    public boolean save(List<BankLoginConfig> bankLoginConfigs, String bankVersionID, String bankVersionName, int maxVersion, String customID) {
        String bankLoginID = bankVersionID + "-" + maxVersion;
        String bankLoginName = bankVersionName + maxVersion;
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bank = bankVersionRepository.loadDynamicObjectByBankVersionID(bankVersionID);
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)BankLoginRepository.ENTITY_NAME);
        dataEntity.set("number", (Object)bankLoginID);
        dataEntity.set("name", (Object)bankLoginName);
        dataEntity.set("group", (Object)bank);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("config_type", (Object)"0");
        dataEntity.set("status", (Object)"A");
        dataEntity.set("enable", (Object)"1");
        try (TXHandle h = TX.requiresNew();){
            bankLoginRepository.save(dataEntity);
            this.configRepository.save(this.buildDynamicObjectList(bankLoginConfigs, bankLoginID, customID));
        }
        return true;
    }

    public void update(List<BankLoginConfig> bankLoginConfigs, String bankLoginID, String customID) {
        try (TXHandle h = TX.requiresNew();){
            this.configRepository.deleteByBankLoginIDAndCustomID(bankLoginID, customID);
            this.configRepository.save(this.buildDynamicObjectList(bankLoginConfigs, bankLoginID, customID));
        }
    }

    public void saveBankLoginConfig(String key, String value, String bankLoginId, String customId) {
        DynamicObject dynamicObject = this.configRepository.loadByBankLoginIDAndCustomIDAndBankConfigID(bankLoginId, customId, key);
        if (dynamicObject != null) {
            dynamicObject.set("bank_config_value", (Object)value);
            SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new DynamicObject[]{dynamicObject});
            return;
        }
    }

    List<DynamicObject> buildDynamicObjectList(List<BankLoginConfig> bankLoginConfigs, String bankLoginID, String customID) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(1);
        bankLoginConfigs.stream().forEach(b -> {
            DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)this.configRepository.ENTITY_KEY);
            dataEntity.set("number", (Object)bankLoginID);
            dataEntity.set("bank_config_id", (Object)b.getKey().getBankConfigId());
            dataEntity.set("name", (Object)b.getBankConfigName());
            dataEntity.set("bank_version_id", (Object)b.getKey().getBankVersionId());
            dataEntity.set("bank_config_value", (Object)b.getBankConfigValue());
            dataEntity.set("nullable", (Object)b.getNullable());
            dataEntity.set("readonly", (Object)b.getReadOnly());
            dataEntity.set("custom_id", (Object)customID);
            dataEntity.set("config_type", (Object)("receipt".equalsIgnoreCase(MetaDataConfigType.getTypeByName(b.getType())) ? "receipt" : "ebg"));
            result.add(dataEntity);
        });
        return result;
    }

    public int getMaxVersionValue(String bankVersionID) {
        return this.getMaxVersionValue(bankVersionID, RequestContext.get().getTenantId());
    }

    public int getMaxVersionValue(String bankVersionID, String customID) {
        QFilter[] qFilters = new QFilter[]{new QFilter("group.number", "=", (Object)bankVersionID)};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)BankLoginRepository.ENTITY_NAME, (String)"number", (QFilter[])qFilters);
        if (dynamicObjectCollection != null) {
            int currentVersion = 0;
            int maxVersion = 0;
            ArrayList<Integer> orgNums = new ArrayList<Integer>(1);
            for (DynamicObject row : dynamicObjectCollection) {
                try {
                    String bankLogin = (String)row.get("number");
                    currentVersion = Integer.parseInt(bankLogin.split("-")[1]);
                    maxVersion = currentVersion > maxVersion ? currentVersion : maxVersion;
                    orgNums.add(currentVersion);
                }
                catch (Exception e) {
                    currentVersion = 1;
                    orgNums.add(currentVersion);
                }
            }
            if (maxVersion > orgNums.size()) {
                for (int i = 1; i <= maxVersion; ++i) {
                    if (orgNums.contains(i)) continue;
                    maxVersion = i - 1;
                    break;
                }
            }
            return ++maxVersion;
        }
        return 1;
    }

    public List<BankLoginConfig> getBankLoginConfigByBankLogin(String bankLoginID, String customID) {
        return this.configRepository.getBankLoginConfigByBankLogin(bankLoginID, customID);
    }

    public boolean isProxy(String customID, String bankLogin) {
        QFilter filter = QFilter.of((String)"custom_id = ? and bank_login_id = ?", (Object[])new Object[]{customID, bankLogin});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_proxy_bank_login", (QFilter[])filter.toArray());
        return dynamicObject != null;
    }
}

