/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.codeless;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.model.codeless.CodeLessRespResultParam;
import kd.ebg.egf.common.repository.codeless.CodeLessRepository;

public class CodeLessService {
    private static CodeLessService instance = new CodeLessService();
    private CodeLessRepository codeLessRepository = CodeLessRepository.getInstance();
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CodeLessService.class);

    public static CodeLessService getInstance() {
        return instance;
    }

    public CodeLess getCodeLessByBankVersionIDAndInterfaceCode(String bankVersionID, String interfaceCode) {
        CodeLess codeLess = this.codeLessRepository.findByBankVersionIDAndInterfaceCode(bankVersionID, interfaceCode);
        if (codeLess == null) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u5b58\u5728", (String)"CodeLessService_0", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        return CodeLessService.validStatus(codeLess);
    }

    public CodeLess getCodeLessByBankVersionIDAndInterfaceCode(String bankVersionID, String bizType, String interfaceCode) {
        CodeLess codeLess = this.codeLessRepository.findByBankVersionIDAndInterfaceCode(bankVersionID, bizType, interfaceCode);
        if (codeLess == null) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u5b58\u5728", (String)"CodeLessService_0", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        return CodeLessService.validStatus(codeLess);
    }

    private static CodeLess validStatus(CodeLess codeLess) {
        if (!"C".equals(codeLess.getStatus())) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u672a\u5ba1\u6838\uff0c\u8bf7\u5148\u5230\u3010\u94f6\u884c\u63a5\u53e3\u7ba1\u7406\u5217\u8868\u3011\u63d0\u4ea4\u5ba1\u6838", (String)"CodeLessService_1", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        if (!"1".equals(codeLess.getEnable())) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u5230\u3010\u94f6\u884c\u63a5\u53e3\u7ba1\u7406\u5217\u8868\u3011\u542f\u7528", (String)"CodeLessService_2", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        return codeLess;
    }

    public String getResponseResult(CodeLessRespResultParam param, String app) {
        return this.codeLessRepository.findLogicByBankVersionIDAndInterfaceCode(param, app);
    }

    public CodeLess getCodeLessByBankVersionIDAndInterfaceCodeAndApp(String bankVersionID, String interfaceCode, String app) {
        CodeLess codeLess = this.codeLessRepository.findByBankVersionIDAndInterfaceCodeAndApp(bankVersionID, interfaceCode, app);
        if (codeLess == null) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u5b58\u5728", (String)"CodeLessService_0", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        return CodeLessService.validStatus(codeLess);
    }

    public CodeLess getCodeLessByBankVersionIDAndInterfaceCodeAndApp(String bankVersionID, String bizType, String interfaceCode, String app) {
        CodeLess codeLess = this.codeLessRepository.findByBankVersionIDAndInterfaceCodeAndApp(bankVersionID, bizType, interfaceCode, app);
        if (codeLess == null) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u5b58\u5728", (String)"CodeLessService_0", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        return CodeLessService.validStatus(codeLess);
    }

    public CodeLess getCodeLessByBankVersionIDAndInterfaceCodeNull(String bankVersionID, String bizType, String interfaceCode, String app) {
        CodeLess codeLess = this.codeLessRepository.findByBankVersionIDAndInterfaceCodeAndApp(bankVersionID, bizType, interfaceCode, app);
        if (codeLess == null) {
            return null;
        }
        return CodeLessService.validStatusNULL(codeLess);
    }

    private static CodeLess validStatusNULL(CodeLess codeLess) {
        if (!"C".equals(codeLess.getStatus())) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u672a\u5ba1\u6838\uff0c\u8bf7\u5148\u5230\u3010\u94f6\u884c\u63a5\u53e3\u7ba1\u7406\u5217\u8868\u3011\u63d0\u4ea4\u5ba1\u6838", (String)"CodeLessService_1", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        if (!"1".equals(codeLess.getEnable())) {
            return null;
        }
        return codeLess;
    }
}

