/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.currency;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.currency.IsoCurrency;
import kd.ebg.egf.common.repository.currency.IsoCurrencyRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoCurrencyService {
    private static Logger logger = LoggerFactory.getLogger(IsoCurrencyService.class);
    private IsoCurrencyRepository isoCurrencyRepository = IsoCurrencyRepository.getInstance();
    private static IsoCurrencyService instance = new IsoCurrencyService();

    public static IsoCurrencyService getInstance() {
        return instance;
    }

    public List<IsoCurrency> selectAll() {
        return this.isoCurrencyRepository.findAll();
    }

    public String getCurrencyName(String isoCode) {
        return Optional.ofNullable(this.isoCurrencyRepository.findOne(isoCode)).map(IsoCurrency::getCurrencyName).orElseThrow(() -> new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u4e0d\u652f\u6301\u7684\u6807\u51c6\u5e01\u79cd%s\u3002", (String)"IsoCurrencyService_1", (String)"ebg-egf-common", (Object[])new Object[0]), isoCode)));
    }

    public void checkIsoCurrency(String isoCode) {
        this.getCurrencyName(isoCode);
    }

    public String checkCurrencyName(String isoCode) {
        return Optional.ofNullable(this.isoCurrencyRepository.findOneDefaultNull(isoCode)).map(IsoCurrency::getCurrencyName).orElseThrow(() -> new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u4e0d\u652f\u6301\u7684\u6807\u51c6\u5e01\u79cd%s\u3002", (String)"IsoCurrencyService_1", (String)"ebg-egf-common", (Object[])new Object[0]), isoCode)));
    }
}

