/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.codeless;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.model.codeless.JudgingConditionBody;

public class JudgingConditionRepository {
    private static JudgingConditionRepository instance = new JudgingConditionRepository();
    private static final String ENTITY_NAME = "ebg_judging_condition";

    public static JudgingConditionRepository getInstance() {
        return instance;
    }

    public List<JudgingConditionBody> findByNumber(String number) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        return this.transJudgingCondition(dynamicObject);
    }

    private List<JudgingConditionBody> transJudgingCondition(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        ArrayList<JudgingConditionBody> result = new ArrayList<JudgingConditionBody>(16);
        DynamicObjectCollection bodyCollection = dynamicObject.getDynamicObjectCollection("note_judging_body");
        if (!bodyCollection.isEmpty()) {
            ArrayList<JudgingConditionBody> judgingConditionBodys = new ArrayList<JudgingConditionBody>(16);
            for (DynamicObject bodyObject : bodyCollection) {
                JudgingConditionBody judgingConditionBody = new JudgingConditionBody();
                judgingConditionBody.setEntryID(bodyObject.getLong("id"));
                judgingConditionBody.setSeq(bodyObject.getInt("seq"));
                judgingConditionBody.setEbgParam(bodyObject.getString("ebgparam"));
                judgingConditionBody.setEbgParamSource(bodyObject.getString("ebgparam_source"));
                judgingConditionBody.setEbgFieldType(bodyObject.getString("ebg_field_type"));
                judgingConditionBody.setFilterCompare(bodyObject.getString("filter_compare"));
                judgingConditionBody.setFilterLeftBracket(bodyObject.getString("filter_left_bracket"));
                judgingConditionBody.setFilterRightBracket(bodyObject.getString("filter_right_bracket"));
                judgingConditionBody.setFilterLink(bodyObject.getString("filter_link"));
                judgingConditionBody.setValue(bodyObject.getString("value"));
                judgingConditionBody.setNode(bodyObject.getString("node"));
                judgingConditionBodys.add(judgingConditionBody);
            }
            result.addAll(judgingConditionBodys);
        }
        return result;
    }
}

