/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.tenant;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.model.tenant.Tenants;
import kd.ebg.egf.common.utils.DTFactoryUtil;

public class TenantRespository {
    private String TENANT_ENTITY = "aqap_bl_tenant";
    private String SELECT_PROPERTIES = "custom_id,custom_name,phone,email,createtime,modifytime,biz_system,bd_biz_sys";
    private static TenantRespository instance = new TenantRespository();

    public static TenantRespository getInstance() {
        return instance;
    }

    public Tenants findByCustomNo(String customNo) {
        Tenants tenants = new Tenants();
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customNo});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.TENANT_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            tenants.setName(dynamicObject.getString("custom_name"));
            tenants.setCustomNo(customNo);
            tenants.setBizSystem(dynamicObject.getString("biz_system"));
            tenants.setInsertTime(DTFactoryUtil.parseDateTime(dynamicObject.getString("createtime")));
            tenants.setUpdateTime(DTFactoryUtil.parseDateTime(dynamicObject.getString("modifytime")));
            tenants.setGroupId(0L);
            tenants.setPhone(dynamicObject.getString("phone"));
            tenants.setEmail(dynamicObject.getString("email"));
            return tenants;
        }
        return null;
    }

    public DynamicObject loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.TENANT_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public void save(Tenants tenant) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{tenant.getCustomNo()});
        boolean isExist = QueryServiceHelper.exists((String)this.TENANT_ENTITY, (QFilter[])filter.toArray());
        if (isExist) {
            this.update(tenant);
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.TENANT_ENTITY);
            dynamicObject.set("custom_id", (Object)tenant.getCustomNo());
            dynamicObject.set("custom_name", (Object)tenant.getName());
            Date insertTime = Date.from(tenant.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("createtime", (Object)insertTime);
            Date updateTime = Date.from(tenant.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("modifytime", (Object)updateTime);
            dynamicObject.set("phone", (Object)tenant.getPhone());
            dynamicObject.set("email", (Object)tenant.getEmail());
            dynamicObject.set("biz_system", (Object)tenant.getBizSystem());
            dynamicObject.set("bd_biz_sys", (Object)this.getBizSys(tenant.getBizSystem()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void update(Tenants tenant) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{tenant.getCustomNo()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.TENANT_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            if (StringUtils.isNotEmpty((String)tenant.getName())) {
                dynamicObject.set("custom_name", (Object)tenant.getName());
            }
            Date updateTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("modifytime", (Object)updateTime);
            dynamicObject.set("phone", (Object)tenant.getPhone());
            dynamicObject.set("email", (Object)tenant.getEmail());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private DynamicObject getBizSys(String bizSysId) {
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bizSysId});
        return BusinessDataServiceHelper.loadSingle((String)"aqap_bd_biz_sys", (String)"", (QFilter[])filter.toArray());
    }
}

