/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import kd.bos.id.ID;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankSerialNo;
import kd.ebg.egf.common.repository.BankSerialNoRepository;

public class Sequence {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Sequence.class);
    private static Sequence instance = new Sequence();
    private static long time = 40000L;
    private static long firstAccessTime = System.currentTimeMillis();
    private static boolean timeKilled = true;
    public static final String EB_SEQUENCE = "eb_sequence";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v'};
    private static final char[] hex29Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's'};
    private static final char[] hex23Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'};
    private static final char[] hex15Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e'};
    private static final char[] hex62Digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f', 'G', 'g', 'H', 'h', 'I', 'i', 'J', 'j', 'K', 'k', 'L', 'l', 'M', 'm', 'N', 'n', 'O', 'o', 'P', 'p', 'Q', 'q', 'R', 'r', 'S', 's', 'T', 't', 'U', 'u', 'V', 'v', 'W', 'w', 'X', 'x', 'Y', 'y', 'Z', 'z'};

    public static Sequence getInstance() {
        return instance;
    }

    public static synchronized boolean init() {
        if (firstAccessTime <= 0L) {
            firstAccessTime = System.currentTimeMillis();
        }
        return true;
    }

    private static void killSensitiveInterval() {
        if (timeKilled) {
            return;
        }
        long gap = System.currentTimeMillis() - firstAccessTime;
        if (gap < time) {
            try {
                logger.info("\u521d\u59cb\u5316\u6d41\u6c34\u53f7\u751f\u6210\u5668...");
                long startTime = System.currentTimeMillis();
                Thread.sleep(time - gap);
                timeKilled = true;
                long finishTime = System.currentTimeMillis();
                logger.info("\u6d41\u6c34\u53f7\u751f\u6210\u5668\u521d\u59cb\u5316\u5b8c\u6210,\u5171\u8017\u65f6" + (finishTime - startTime) + "\u6beb\u79d2");
            }
            catch (Throwable t) {
                timeKilled = false;
                logger.error("\u521d\u59cb\u5316\u6d41\u6c34\u53f7\u751f\u6210\u5668\u5f02\u5e38\u3002\u53c2\u8003\u539f\u56e0:");
                logger.error("\u6d41\u6c34\u53f7\u7cfb\u7edf\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38\uff0c\u7cfb\u7edf\u81ea\u52a8\u5173\u95ed\u3002\u8bf7\u91cd\u65b0\u542f\u52a8\u94f6\u4f01\u5e73\u53f0\u3002");
                System.exit(-1);
            }
        } else {
            timeKilled = true;
        }
    }

    public static synchronized String gen8Sequence() {
        String sequence;
        long id;
        boolean exsist;
        BankSerialNoRepository bankSerialNoRepository = BankSerialNoRepository.getInstance();
        EBContext context = EBContext.getContext();
        do {
            id = ID.genLongId() + 200000000000000000L;
            sequence = String.valueOf(id);
            id = Long.parseLong(sequence.substring(0, 14));
            BankSerialNo bankSerialNo = new BankSerialNo();
            bankSerialNo.setBankVersionId(context.getBankVersionID());
            bankSerialNo.setCustomId(context.getCustomID());
            bankSerialNo.setNumber(id + "");
            try {
                bankSerialNoRepository.save(bankSerialNo);
                exsist = false;
            }
            catch (Throwable e) {
                exsist = true;
            }
        } while (exsist);
        sequence = Sequence.toMaxScale(id);
        return sequence;
    }

    public static synchronized String genSequence() {
        long id = ID.genLongId() + 200000000000000000L;
        return Sequence.to19_13Scale(id);
    }

    public static synchronized String gen14Sequence() {
        long id = ID.genLongId() + 200000000000000000L;
        return Sequence.to19_14Scale(id);
    }

    public static synchronized long gen16NumSequence() {
        long id;
        boolean exsist;
        BankSerialNoRepository bankSerialNoRepository = BankSerialNoRepository.getInstance();
        EBContext context = EBContext.getContext();
        do {
            id = ID.genLongId() + 200000000000000000L;
            String sequence = String.valueOf(id);
            id = Long.parseLong(sequence.substring(0, 16));
            BankSerialNo bankSerialNo = new BankSerialNo();
            bankSerialNo.setBankVersionId(context.getBankVersionID());
            bankSerialNo.setCustomId(context.getCustomID());
            bankSerialNo.setNumber(id + "");
            try {
                bankSerialNoRepository.save(bankSerialNo);
                exsist = false;
            }
            catch (Throwable e) {
                exsist = true;
            }
        } while (exsist);
        return id;
    }

    public static synchronized String gen16Sequence() {
        long id = ID.genLongId() + 200000000000000000L;
        return Sequence.to19_16Scale(id);
    }

    public static synchronized String gen18Sequence() {
        long id = ID.genLongId() + 200000000000000000L;
        String sequence = String.valueOf(id);
        return sequence;
    }

    private static String toHexString(long x) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            char c = hexDigits[(int)(x & 0xFL)];
            sb.insert(0, c);
            x >>>= 4;
        }
        return new String(sb);
    }

    public static String to32Scale(long x) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 13; ++i) {
            char c = hexDigits[(int)(x & 0x1FL)];
            sb.insert(0, c);
            x >>>= 5;
        }
        return new String(sb);
    }

    public static String to8Scale(long x) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            char c = hexDigits[(int)(x & 0x1FL)];
            sb.insert(0, c);
            x >>>= 5;
        }
        return new String(sb);
    }

    public static String to19_13Scale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 29L);
            sb.append(hex29Digits[mod]);
        } while ((v /= 29L) != 0L);
        return sb.reverse().toString();
    }

    public static String to19_14Scale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 23L);
            sb.append(hex23Digits[mod]);
        } while ((v /= 23L) != 0L);
        return sb.reverse().toString();
    }

    public static String to19_16Scale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 15L);
            sb.append(hex15Digits[mod]);
        } while ((v /= 15L) != 0L);
        return sb.reverse().toString();
    }

    public static String toMaxScale(long v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = (int)(v % 62L);
            sb.append(hex62Digits[mod]);
        } while ((v /= 62L) != 0L);
        return sb.reverse().toString();
    }
}

