/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.file;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.ZipFile;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.CleanPathUtil;

public class FileCommonUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FileCommonUtils.class);
    private static final String FILE_NAME_SUFFIX = ".";

    public static String checkPath(String path) {
        path = CleanPathUtil.cleanString(path);
        return path;
    }

    public static File getFileByPath(String path) {
        String temp = FileCommonUtils.checkPath(path);
        File file = new File(temp);
        return file;
    }

    public static File getFileByPath(String path, String fileName) {
        String url = path + File.separator + fileName;
        String temp = FileCommonUtils.checkPath(url);
        File file = new File(temp);
        return file;
    }

    public static ZipFile getZipFileByPath(String filePath, Charset charset) throws IOException {
        String checkPath = FileCommonUtils.checkPath(filePath);
        ZipFile file = new ZipFile(checkPath, charset);
        return file;
    }
}

