/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.string;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.apache.commons.codec.binary.Base64;

public class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String joinWithSplit(char split, String ... param) {
        return StringUtils.joinWithSplit(String.valueOf(split), param);
    }

    public static String joinWithSplit(String split, String ... param) {
        StringBuilder sb = new StringBuilder();
        for (String s : param) {
            sb.append(s).append(split);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String[] split(String line, int seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(16);
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            list.add(line.substring(i, j).trim());
            i = j + 1;
        }
        list.add(line.substring(i).trim());
        int size = list.size();
        String[] ps = list.toArray(new String[size]);
        return ps;
    }

    public static String[] split(String line, String seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        ArrayList<String> list = new ArrayList<String>(16);
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            list.add(line.substring(i, j).trim());
            i = j + seperator.length();
        }
        list.add(line.substring(i).trim());
        int size = list.size();
        String[] ps = list.toArray(new String[size]);
        return ps;
    }

    public static boolean isChinaPhoneLegal(String str) {
        String regExp = "^((13[0-9])|(14[5,7,9])|(15[0-3,5-9])|(166)|(17[3,5,6,7,8])|(18[0-9])|(19[8,9]))\\d{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean equals(String s1, String s2) {
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static final String replace(String str, String oldChars, String newChars) {
        int pos;
        int len = newChars.length();
        int lastPos = pos = str.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = str.indexOf(oldChars, lastPos);
        }
        return str;
    }

    public static String byteToString(byte[] bytes, String charsetName) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        Charset charset = Charset.forName(charsetName);
        CharBuffer charBuffer = charset.decode(byteBuffer);
        char[] chars = charBuffer.array();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String byteToString(byte[] bytes, Charset charset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        CharBuffer charBuffer = charset.decode(byteBuffer);
        char[] chars = charBuffer.array();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String byteToString(byte[] bytes) {
        Charset charset = Charset.forName("UTF-8");
        return StringUtils.byteToString(bytes, charset);
    }

    public static String left(String str, int n) {
        return str.substring(str.length() - n);
    }

    public static String right(String str, int n) {
        return str.substring(str.length() - n, str.length());
    }

    public static String trim(String str) {
        return str != null ? str.trim() : "";
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String catWithSpace(String ... ss) {
        return StringUtils.cat(" ", ss);
    }

    public static String cat(String seperator, String[] ss) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ss.length; ++i) {
            if (!StringUtils.isEmpty(sb.toString())) {
                sb.append(seperator);
            }
            if (StringUtils.isEmpty(ss[i])) continue;
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    public static String[] split2Lines(String str) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(bais));
        String line = null;
        ArrayList<String> list = new ArrayList<String>(16);
        do {
            if (null == (line = br.readLine())) continue;
            list.add(line);
        } while (null != line);
        return list.toArray(new String[0]);
    }

    public static String stringArrayToString(String[] array) {
        return StringUtils.stringArrayToString(array, ",");
    }

    public static String stringArrayToString(String[] array, String splitChar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(splitChar);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    public static String trim(Object obj) {
        return StringUtils.trim(StringUtils.toString(obj));
    }

    public static Object xml2Obj(String xml) {
        return "";
    }

    public static String substringChinese(String srcStr, String charset, int maxByteLength) {
        if (StringUtils.isEmpty(srcStr)) {
            return "";
        }
        if (srcStr.length() * 2 <= maxByteLength) {
            return srcStr;
        }
        char[] srcChrs = srcStr.toCharArray();
        int totalLength = 0;
        StringBuilder retStr = new StringBuilder();
        for (char chr : srcChrs) {
            try {
                totalLength += String.valueOf(chr).getBytes(charset).length;
            }
            catch (UnsupportedEncodingException e) {
                totalLength += chr > '\u00ff' ? 2 : 1;
            }
            if (totalLength > maxByteLength) break;
            retStr.append(chr);
        }
        return retStr.toString();
    }

    public static char[] byte2String(byte[] source, String charset) {
        try {
            Charset cs = Charset.forName(charset);
            ByteBuffer bb = ByteBuffer.allocate(source.length);
            bb.put(source).flip();
            CharBuffer cb = cs.decode(bb);
            return cb.array();
        }
        catch (Exception var5) {
            throw new EBServiceException(var5);
        }
    }

    public static String byte2String(byte[] source) {
        char[] chars = StringUtils.byte2String(source, "UTF-8");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static String bytes2String(byte[] source, String charset) {
        char[] chars = StringUtils.byte2String(source, charset);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static String bytes2String(byte[] source, Charset charset) {
        char[] chars = StringUtils.byte2String(source, charset.name());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static boolean checkBase64(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        Boolean isLegal = str.matches(base64Pattern);
        if (isLegal.booleanValue()) {
            try {
                String decStr = new String(new Base64().decode(str.getBytes()), StandardCharsets.UTF_8);
                char[] passArr = decStr.toCharArray();
                for (int i = 0; i < passArr.length; ++i) {
                    if (StringUtils.charToByteAscii2(passArr[i]) >= 32 && StringUtils.charToByteAscii2(passArr[i]) <= 126) continue;
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static byte charToByteAscii2(char ch) {
        byte byteAscii = (byte)ch;
        return byteAscii;
    }

    public static String norm(String source) {
        if (source == null) {
            return null;
        }
        if (StringUtils.isEmpty(source)) {
            return source;
        }
        int len = source.length() + 1;
        StringBuilder sb = new StringBuilder(source).append("\u3002");
        LinkedList<Character> stack = new LinkedList<Character>();
        HashSet<Character> punctuation = new HashSet<Character>(7);
        punctuation.add(Character.valueOf('.'));
        punctuation.add(Character.valueOf(','));
        punctuation.add(Character.valueOf('\uff0c'));
        punctuation.add(Character.valueOf('\u3002'));
        punctuation.add(Character.valueOf('\uff01'));
        punctuation.add(Character.valueOf('!'));
        punctuation.add(Character.valueOf(' '));
        punctuation.add(Character.valueOf(';'));
        punctuation.add(Character.valueOf('\uff1b'));
        punctuation.add(Character.valueOf('\uff1a'));
        punctuation.add(Character.valueOf(':'));
        for (int i = 0; i < len; ++i) {
            if (!stack.isEmpty() && punctuation.contains(Character.valueOf(sb.charAt(i))) && punctuation.contains(stack.peek())) {
                if ('\u3002' == sb.charAt(i)) continue;
                stack.pop();
                stack.push(Character.valueOf(sb.charAt(i)));
                continue;
            }
            stack.push(Character.valueOf(sb.charAt(i)));
        }
        StringBuilder res = new StringBuilder();
        for (Character character : stack) {
            res.append(character);
        }
        return res.reverse().toString();
    }

    public static String cleanPath(String path) {
        int i;
        String normalizedPath;
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        String pathToUse = normalizedPath = StringUtils.replace(path, "\\", "/");
        if (normalizedPath.indexOf(46) == -1) {
            return normalizedPath;
        }
        int prefixIndex = normalizedPath.indexOf(58);
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = normalizedPath.substring(0, prefixIndex + 1);
            if (prefix.contains("/")) {
                prefix = "";
            } else {
                pathToUse = normalizedPath.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, "/");
        ArrayDeque<String> pathElements = new ArrayDeque<String>(pathArray.length);
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.addFirst(element);
        }
        if (pathArray.length == pathElements.size()) {
            return normalizedPath;
        }
        for (i = 0; i < tops; ++i) {
            pathElements.addFirst("..");
        }
        if (pathElements.size() == 1 && ((String)pathElements.getLast()).isEmpty() && !prefix.endsWith("/")) {
            pathElements.addFirst(".");
        }
        String joined = StringUtils.collectionToDelimitedString(pathElements, "/");
        return prefix.isEmpty() ? joined : prefix + joined;
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtil.isEmpty(coll)) {
            return "";
        }
        int totalLength = coll.size() * (prefix.length() + suffix.length()) + (coll.size() - 1) * delim.length();
        for (Object element : coll) {
            totalLength += String.valueOf(element).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int pos = 0; pos < str.length(); ++pos) {
                result.add(StringUtils.deleteAny(str.substring(pos, pos + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return !CollectionUtil.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.isNotEmpty(inString) && StringUtils.isNotEmpty(charsToDelete)) {
            int lastCharIndex = 0;
            char[] result = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                char c = inString.charAt(i);
                if (charsToDelete.indexOf(c) != -1) continue;
                result[lastCharIndex++] = c;
            }
            if (lastCharIndex == inString.length()) {
                return inString;
            }
            return new String(result, 0, lastCharIndex);
        }
        return inString;
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(47);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }
}

