/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.zookeeper.client;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.ebg.egf.common.zookeeper.client.ZookeeperClient;
import kd.ebg.egf.common.zookeeper.cluster.URL;
import kd.ebg.egf.common.zookeeper.listener.ChildListener;
import kd.ebg.egf.common.zookeeper.listener.StateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZookeeperClient<TargetChildListener>
implements ZookeeperClient {
    protected final Logger logger = LoggerFactory.getLogger(AbstractZookeeperClient.class);
    private final URL url;
    private static final Set<StateListener> stateListeners = new CopyOnWriteArraySet<StateListener>();
    private final ConcurrentMap<String, ConcurrentMap<ChildListener, TargetChildListener>> childListeners = new ConcurrentHashMap<String, ConcurrentMap<ChildListener, TargetChildListener>>(1);
    private volatile boolean closed = false;

    public AbstractZookeeperClient(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void create(String path, String data, boolean ephemeral) {
        if (ephemeral) {
            this.createEphemeral(path, data);
        } else {
            this.createPersistent(path, data);
        }
    }

    @Override
    public void addStateListener(StateListener listener) {
        stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(StateListener listener) {
        stateListeners.remove(listener);
    }

    public Set<StateListener> getSessionListeners() {
        return stateListeners;
    }

    @Override
    public List<String> addChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners == null) {
            this.childListeners.putIfAbsent(path, new ConcurrentHashMap());
            listeners = (ConcurrentMap)this.childListeners.get(path);
        }
        if ((targetListener = listeners.get(listener)) == null) {
            listeners.putIfAbsent(listener, this.createTargetChildListener(path, listener));
            targetListener = listeners.get(listener);
        }
        return this.addTargetChildListener(path, targetListener);
    }

    @Override
    public void removeChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners != null && (targetListener = listeners.remove(listener)) != null) {
            this.removeTargetChildListener(path, targetListener);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.doClose();
        }
        catch (Throwable t) {
            this.logger.info(t.getMessage(), t);
        }
    }

    protected void stateChanged(int state) {
        for (StateListener sessionListener : this.getSessionListeners()) {
            sessionListener.stateChanged(state);
        }
    }

    protected abstract void doClose();

    protected abstract void createPersistent(String var1, String var2);

    protected abstract void createEphemeral(String var1, String var2);

    protected abstract TargetChildListener createTargetChildListener(String var1, ChildListener var2);

    protected abstract List<String> addTargetChildListener(String var1, TargetChildListener var2);

    protected abstract void removeTargetChildListener(String var1, TargetChildListener var2);

    @Override
    public abstract boolean checkNodeExist(String var1);
}

