/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;

public class DataToJsonFormatUtils {
    private static String ARRAY = "repeat_node";
    private static String OBJECT = "structure_node";
    private static String ATTR = "attribute_node";

    public static Map<String, Object> getFormatDataMap(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        Map<String, Object> resultMap = DataToJsonFormatUtils.packageJsonFormat(collection, tops, typeKey, nameKey, valueKey);
        return resultMap;
    }

    public static String getJsonFormatData(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        Map<String, Object> resultMap = DataToJsonFormatUtils.packageJsonFormat(collection, tops, typeKey, nameKey, valueKey);
        return JSON.toJSONString(resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, List<DynamicObject> tops, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>(16);
        for (DynamicObject top : tops) {
            String key = top.getString(nameKey);
            String type = top.getString(typeKey);
            if (!ARRAY.equals(type) && !OBJECT.equals(type)) {
                String value = StringUtils.isEmpty((String)valueKey) ? "" : top.getString(valueKey);
                responseMap.put(key, value);
                continue;
            }
            if (ARRAY.equals(type)) {
                responseMap.put(key, DataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, top));
                continue;
            }
            responseMap.put(key, DataToJsonFormatUtils.packageJsonFormat(dynamicObjects, top, typeKey, nameKey, valueKey));
        }
        return responseMap;
    }

    private static List<Object> getArrayFormatData(DynamicObjectCollection dynamicObjects, String typeKey, String nameKey, String valueKey, DynamicObject parent) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        int filedCount = 0;
        int subFiledCount = 0;
        Iterator var8 = dynamicObjects.iterator();
        while (true) {
            String value;
            if (!var8.hasNext()) {
                if (filedCount == subFiledCount) {
                    return list;
                }
                list.clear();
                list.add(DataToJsonFormatUtils.packageJsonFormat(dynamicObjects, parent, typeKey, nameKey, valueKey));
                return list;
            }
            DynamicObject response = (DynamicObject)var8.next();
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String string = value = StringUtils.isEmpty((String)valueKey) ? "" : response.getString(valueKey);
            if (!parent.getPkValue().toString().equals(response.getString("pid"))) continue;
            ++subFiledCount;
            if (!StringUtils.isBlank((String)key)) continue;
            ++filedCount;
            if (!ARRAY.equals(type) && !OBJECT.equals(type)) {
                list.add(value);
                continue;
            }
            if (OBJECT.equals(type)) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(DataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                list.add(data);
                continue;
            }
            list.add(DataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, DynamicObject object, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(16);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            String value;
            DynamicObject response = (DynamicObject)dynamicObjects.get(i);
            if (!object.getPkValue().toString().equals(response.getString("pid"))) continue;
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String string = value = StringUtils.isEmpty((String)valueKey) ? "" : response.getString(valueKey);
            if (!ARRAY.equals(type) && !OBJECT.equals(type)) {
                if (ATTR.equals(type)) {
                    result.put(key, response.getLong("pid"));
                    continue;
                }
                if (i < dynamicObjects.size() - 1) {
                    DynamicObject next = (DynamicObject)dynamicObjects.get(i + 1);
                    if (response.getPkValue().toString().equals(next.getString("pid"))) {
                        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(1);
                        data.putAll(DataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                        result.put(key, data);
                        continue;
                    }
                    result.put(key, value);
                    continue;
                }
                result.put(key, value);
                continue;
            }
            if (OBJECT.equals(type)) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(DataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                result.put(key, data);
                continue;
            }
            result.put(key, DataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        return result;
    }
}

