/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.payable.Revocation;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryRevocationImpl
extends AbstractQueryNotePayableImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        LoginUtils.login();
        NotePayableInfo[] infos = bankNotePayableRequest.getNotePayableInfosAsArray();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEQ508", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        NotePayableInfo info = infos[0];
        JDomExtUtils.addChildCDData(common, "ExgBill_Plc_Bl_CtCd", infos[0].getDraftType());
        JDomExtUtils.addChildCDData(common, "Bill_No", infos[0].getBillNo());
        String grdBag = info.getGrdBag();
        if (StringUtils.isEmpty((String)grdBag)) {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", "0");
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", "0");
        } else {
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_Strt_SN", info.getStartNo());
            JDomExtUtils.addChildCDData(common, "SbBll_Rng_End_SN", info.getEndNo());
        }
        JDomExtUtils.addChildCDData(common, "Enqr_StDt", LocalDateUtil.formatDate((LocalDateTime)info.getSubmitSuccessTime()));
        JDomExtUtils.addChildCDData(common, "QRY_END_DT", LocalDateUtil.formatDate((LocalDateTime)info.getSubmitSuccessTime()));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List infos = bankNotePayableRequest.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002\u3002", (String)"QueryRevocationImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List lists = response.getChildren("BkPjxx_GRP");
            NotePayableInfo info = (NotePayableInfo)infos.get(0);
            for (Element list : lists) {
                String TxnSrlNo = JDomUtils.getChildTextTrim((Element)list, (String)"TxnSrlNo");
                if (!TxnSrlNo.equals(info.getObssid())) continue;
                String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"TRN_ST_CD");
                String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"Txn_RsltCmnt");
                String noteStatus = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_StCd");
                String cirStatus = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_Crcl_IndCd");
                info.setNoteStatus(noteStatus);
                info.setCirStatus(cirStatus);
                if (BkFlag2.equals("12")) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkFlag2, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QueryRevocationImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (BkFlag2.equals("02") || BkFlag2.equals("04") || BkFlag2.equals("01") || BkFlag2.equals("00") || BkFlag2.equals("10")) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkFlag2, (String)String.format(ResManager.loadKDString((String)"\u5f85\u7b7e\u6536%s", (String)"QueryRevocationImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
                    continue;
                }
                if (BkFlag2.equals("20") || BkFlag2.equals("21") || BkFlag2.equals("22") || BkFlag2.equals("23") || BkFlag2.equals("24") || BkFlag2.equals("25")) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkFlag2, (String)BkSumry);
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkFlag2, (String)String.format(ResManager.loadKDString((String)"\u7968\u72b6\u6001\u672a\u77e5%s\u3002", (String)"QueryRevocationImpl_5", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), BkSumry));
            }
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

