/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.receivable.sign;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QuerySignImpl
extends AbstractQueryNoteReceivableImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        LoginUtils.login();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEQ522", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        String code = receivableInfos[0].getOperationCode();
        if ("10".equals(code)) {
            code = "0003";
        } else if ("03".equals(code)) {
            code = "0002";
        } else if ("02".equals(code)) {
            code = "0001";
        } else if ("20".equals(code)) {
            code = "0014";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7b7e\u6536\u7c7b\u578b\uff1a%s\u3002", (String)"SigninImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), code));
        }
        JDomExtUtils.addChildCDData(common, "ExgBill_Plc_Bl_CtCd", receivableInfos[0].getDraftType());
        JDomExtUtils.addChildCDData(common, "Bl_Ansr_TpCd", code);
        JDomExtUtils.addChildCDData(common, "Btch_No", receivableInfos[0].getObssid());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CCBHCBankResponse rsp1 = CommonParser.getFrontResponse(rsp);
        if (!rsp1.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"QueryPledgeImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp1.getResponseCode(), rsp1.getResponseMessage()));
        }
        rsp = rsp1.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List lists = response.getChildren("BkPjxx_GRP");
            for (NoteReceivableInfo info : receivableInfos) {
                for (Element list : lists) {
                    String endNo;
                    String startNo;
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"Bill_No");
                    if (!this.checkNoteNoAndRng(info, BkListNo1, startNo = JDomUtils.getChildTextTrim((Element)list, (String)"SbBll_Rng_Strt_SN"), endNo = JDomUtils.getChildTextTrim((Element)list, (String)"SbBll_Rng_End_SN"))) continue;
                    String Rslt_Tpcd = JDomUtils.getChildTextTrim((Element)list, (String)"Txn_Rslt_TpCd");
                    String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_StCd");
                    String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"EBill_Bl_Crcl_IndCd");
                    String bankRefDate = JDomUtils.getChildTextTrim((Element)list, (String)"SignToAcpt_Dt");
                    String bankRefKey = JDomUtils.getChildTextTrim((Element)list, (String)"Pltfrm_Txn_Tms");
                    info.setBankRefKey(bankRefKey);
                    info.setBankRefDate(bankRefDate);
                    info.setCirStatus(BkSumry);
                    info.setNoteStatus(BkFlag1);
                    if (Rslt_Tpcd.equals("0002")) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)"sign success");
                        continue;
                    }
                    if (Rslt_Tpcd.equals("0001")) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                        continue;
                    }
                    String trn_st_cd = JDomExtUtils.getChildTextTrim((Element)list, (String)"TRN_ST_CD");
                    if ("17".equals(trn_st_cd)) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)BkSumry);
                        continue;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                }
            }
        }
        return receivableInfos;
    }

    public int getBatchSize() {
        return 0;
    }

    public boolean checkNoteNoAndRng(NoteReceivableInfo info, String billNo, String startNo, String endNo) {
        String grdBag = info.getGrdBag();
        if (StringUtils.isEmpty((String)billNo)) {
            return false;
        }
        if (!"1".equals(grdBag)) {
            return billNo.equals(info.getBillNo());
        }
        if (StringUtils.isEmpty((String)startNo) || StringUtils.isEmpty((String)endNo)) {
            return false;
        }
        return billNo.equals(info.getBillNo()) && startNo.equals(info.getStartNo()) && endNo.equals(info.getEndNo());
    }
}

