/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1ECDS256";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5efa\u8bbe\u94f6\u884c - \u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2 \u3002 ", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element response = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String TOTAL_PAGE = response.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        int page = Integer.parseInt(pageTag);
        return page - 1 >= total_page;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1ECDS256", Sequence.genSequence());
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomUtils.addChild((Element)common, (String)"BkType1", (String)request.getBody().getDraftType());
        JDomUtils.addChild((Element)common, (String)"Bk8Date1", (String)"");
        String type = request.getBody().getTranType();
        if ("03".equals(type)) {
            type = "0003";
        } else if ("10".equals(type)) {
            type = "0004";
        } else if ("18".equals(type)) {
            type = "0007";
        } else if ("20".equals(type)) {
            type = "0008";
        } else if ("19".equals(type)) {
            type = "0006";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7968\u636e\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\uff1a%s\u3002", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), type));
        }
        JDomUtils.addChild((Element)common, (String)"BkType2", (String)type);
        JDomUtils.addChild((Element)common, (String)"BkAcctNum", (String)"1");
        Element BkAcctQuery_GRP = JDomUtils.addChild((Element)common, (String)"BkAcctQuery_GRP");
        JDomUtils.addChild((Element)BkAcctQuery_GRP, (String)"BkEcdQueryAcct", (String)request.getAcnt().getAccNo());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5f85\u7b7e\u6536\u7968\u636e\u4fe1\u606f\u94f6\u884c\u8fd4\u56de\u5931\u8d25\uff0c%1$s %2$s\u3002", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode() + "\n", bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List list1 = response.getChildren("BkDqs_GRP");
        ArrayList<Detail> result = new ArrayList();
        result = this.getDetails(request, list1, request.getAcnt());
        return result;
    }

    private List<Detail> getDetails(BankNoteDetailRequest rqst, List<Element> detailLists, BankAcnt ancAcnt) {
        ArrayList<Detail> result = new ArrayList<Detail>();
        for (Element node : detailLists) {
            Detail info = new Detail();
            String type = rqst.getBody().getTranType();
            info.setBusinessCode(type);
            info.setNoteNo(JDomUtils.getChildText((Element)node, (String)"BkListNo1"));
            info.setApplicantAcName(JDomUtils.getChildText((Element)node, (String)"Bk60Name6"));
            info.setApplicantAcNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo6"));
            info.setApplicantBankCnaps(JDomUtils.getChildText((Element)node, (String)"BkBrchNo6"));
            info.setExplain(JDomUtils.getChildText((Element)node, (String)"BkDetail1"));
            info.setBankRefKey(JDomUtils.getChildText((Element)node, (String)"BkOldSeq"));
            String applicationDateStr = JDomUtils.getChildText((Element)node, (String)"BkOldPlatDate");
            info.setApplicationDate(applicationDateStr);
            info.setDraftType(rqst.getBody().getDraftType());
            info.setPayeeAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name2"));
            String accno = JDomUtils.getChildText((Element)node, (String)"BkAcctNo2");
            info.setPayeeAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo2"));
            info.setPayeeCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo2"));
            String remark = JDomUtils.getChildText((Element)node, (String)"Bk60Name8");
            if (!StringUtils.isEmpty((String)remark)) {
                info.setExplain(remark);
            }
            info.setDrawerAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name1"));
            info.setDrawerAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo1"));
            info.setDrawerCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo1"));
            info.setAcceptorAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name3"));
            info.setAcceptorCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo3"));
            String amount = JDomUtils.getChildText((Element)node, (String)"BkAmt1");
            if (!StringUtils.isEmpty((String)amount)) {
                info.setAmount(amount);
            }
            String dueStartDate = JDomUtils.getChildText((Element)node, (String)"Bk8Date1");
            info.setIssueDate(dueStartDate);
            info.setTransferFlag(JDomUtils.getChildText((Element)node, (String)"BkType3"));
            String dueDate = JDomUtils.getChildText((Element)node, (String)"Bk8Date2");
            info.setDueDate(dueDate);
            EndorseInfoImpl impl = new EndorseInfoImpl();
            List<NoteSidesInfo> list = impl.getMessage(JDomUtils.getChildText((Element)node, (String)"BkListNo1"));
            info.setNoteSidesInfo(list);
            this.logger.info("\u83b7\u53d6\u5230\u80cc\u4e66\u8054\u4fe1\u606f");
            String BkFlag1 = JDomUtils.getChildText((Element)node, (String)"BkFlag1");
            info.setNoteStatus(BkFlag1);
            if ("19".equals(type)) {
                if (!"190001".equals(BkFlag1)) continue;
                result.add(info);
                continue;
            }
            result.add(info);
        }
        return result;
    }
}

