/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.note.detail.endorseInfo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteInfoParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NoteInfoParser.class);

    public List<NoteSidesInfo> parseNoteInfoResponse(String rspStr) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u94f6\u884c\u8fd4\u56de\u5931\u8d25\uff0c%1$s %2$s\u3002", (String)"NoteInfoParser_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode() + "\n", bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List detailLists = response.getChildren("Bkplhpcx1_GRP");
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>();
        for (Element detail : detailLists) {
            String info = JDomUtils.getChildText((Element)detail, (String)"BkDetail7");
            this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u4fe1\u606f\uff1a" + info);
            String[] endorseinfo = info.split("\\|\\@\\|\\$");
            for (int i = 0; i < endorseinfo.length; ++i) {
                String signdate;
                NoteSidesInfo infoDetail;
                String eachinfo = endorseinfo[i];
                String[] endorse = eachinfo.split("\\|");
                String type = endorse[0];
                this.logger.info("\u83b7\u53d6\u5230\u7684\u7c7b\u578b\uff1a" + type);
                if ("00".equals(type)) {
                    infoDetail = new NoteSidesInfo();
                    infoDetail.setInitiatorName(endorse[1]);
                    infoDetail.setOpponentName(endorse[2]);
                    signdate = endorse[4];
                    if (!StringUtils.isEmpty((String)signdate)) {
                        infoDetail.setSignDate(signdate);
                    }
                    infoDetail.setTransferFlag(endorse[3]);
                    infoDetail.setBusinessCode("10");
                    infoDetail.setResv1(i + "");
                    if (endorse.length == 6) {
                        infoDetail.setRemark(endorse[5]);
                    }
                    result.add(infoDetail);
                    continue;
                }
                if (!"02".equals(type)) continue;
                infoDetail = new NoteSidesInfo();
                infoDetail.setInitiatorName(endorse[1]);
                infoDetail.setOpponentName(endorse[2]);
                signdate = endorse[3];
                if (!StringUtils.isEmpty((String)signdate)) {
                    infoDetail.setSignDate(signdate);
                }
                infoDetail.setTransferFlag("");
                infoDetail.setBusinessCode("18");
                infoDetail.setResv1(i + "");
                result.add(infoDetail);
            }
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return result;
    }
}

