/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.news.receivable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.news.receivable.cancle.CodelessQueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_NotePacker;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CodelessCancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CodelessCancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return CodelessQueryCancleNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "420202";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u5904\u7406-\u63d0\u793a\u627f\u5151/\u63d0\u793a\u6536\u7968/\u64a4\u56de/\u64a4\u7968\uff08420202\uff09", (String)"CodelessCancleNoteReceivableImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element root = BOCOM_DC_NotePacker.packRootForNote("420202", info.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"QryAcct", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"IdNb", (String)info.getBillNo());
        JDomUtils.addChild((Element)body, (String)"ActionCode", (String)"06");
        JDomUtils.addChild((Element)body, (String)"TxlCtrCtnb", (String)"");
        JDomUtils.addChild((Element)body, (String)"INVCNB", (String)"");
        JDomUtils.addChild((Element)body, (String)"RmrkByPropsr", (String)"");
        JDomUtils.addChild((Element)body, (String)"NoteFlag", (String)"1");
        JDomUtils.addChild((Element)body, (String)"NoteStart", (String)info.getStartNo());
        JDomUtils.addChild((Element)body, (String)"NoteEnd", (String)info.getEndNo());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return noteReceivableInfos;
    }
}

