/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.payable.register;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.GetMessage4Register;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserPayable;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.common.model.NotePayableInfo;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "billregister";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u5904\u7406", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NotePayableInfo> infos = this.parse(request, rspStr);
            return new EBBankNotePayableResponse(infos);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNotePayableResponse(request.getNotePayableInfoList());
        }
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        JSONObject BillRegisterApplyX2;
        JSONArray array5;
        NotePayableInfo info = (NotePayableInfo)request.getNotePayableInfoList().get(0);
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject trxHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            trxHdr.put("cltNbr", (Object)cltNbr);
        } else {
            trxHdr.put("cltNbr", (Object)info.getDrawerAccNo().substring(0, 10));
        }
        array1.add((Object)trxHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject batchBusOprX1 = new JSONObject();
        array2.add((Object)batchBusOprX1);
        batchBusOprX1.put("cnlRef", (Object)SaasUtil.getRnlRef(info.getBankBatchSeqId()));
        batchBusOprX1.put("flwTyp", (Object)"ND0010");
        batchBusOprX1.put("busTyp", (Object)"db");
        batchBusOprX1.put("busSty", (Object)"01");
        batchBusOprX1.put("busTrs", (Object)"OUT");
        batchBusOprX1.put("busStr", (Object)info.getDraftType());
        batchBusOprX1.put("trsAmt", (Object)(info.getAmount() + ""));
        String flwCod = BankBusinessConfig.getBusMod(info.getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u8d26\u53f7\u914d\u7f6e\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"RegisterNotePayableImpl_5", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        batchBusOprX1.put("flwCod", (Object)flwCod);
        batchBusOprX1.put("busTyp", (Object)"DB");
        batchBusOprX1.put("busSty", (Object)"01");
        batchBusOprX1.put("busTrs", (Object)"OUT");
        batchBusOprX1.put("busStr", (Object)info.getDraftType());
        batchBusOprX1.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        batchBusOprX1.put("sndEac", (Object)info.getDrawerAccNo());
        batchBusOprX1.put("ccyNbr", (Object)"10");
        batchBusOprX1.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        batchBusOprX1.put("bchCnt", (Object)"1");
        batchBusOprX1.put("bchTyp", (Object)"OPR");
        body.put("batchBusOprX1", (Object)array2);
        JSONArray array4 = new JSONArray();
        JSONObject BillRegisterApplyX1 = new JSONObject();
        array4.add((Object)BillRegisterApplyX1);
        body.put("BillRegisterApplyX1", (Object)array4);
        BillRegisterApplyX1.put("appTyp", (Object)"RC01");
        BillRegisterApplyX1.put("appEac", (Object)info.getDrawerAccNo());
        BillRegisterApplyX1.put("appTyp", (Object)"RC01");
        BillRegisterApplyX1.put("appSrc", (Object)"CS02");
        BillRegisterApplyX1.put("busCod", (Object)"BC01");
        BillRegisterApplyX1.put("busTyp", (Object)"01");
        BillRegisterApplyX1.put("busCnl", (Object)"EDC");
        BillRegisterApplyX1.put("prxApp", (Object)"PS01");
        BillRegisterApplyX1.put("busCcy", (Object)"10");
        BillRegisterApplyX1.put("busAmt", (Object)(info.getAmount() + ""));
        BillRegisterApplyX1.put("busDat", (Object)DateUtil.formatDate((Date)new Date()));
        BillRegisterApplyX1.put("busCnt", (Object)"1");
        BillRegisterApplyX1.put("bilTyp", (Object)info.getDraftType());
        batchBusOprX1.put("busCnl", (Object)"EDC");
        batchBusOprX1.put("prxApp", (Object)"PS01");
        batchBusOprX1.put("busCcy", (Object)"10");
        boolean sameBank = SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getAcceptorBankName()).equals("1");
        if ("AC01".equals(info.getDraftType()) && sameBank) {
            String balEac;
            array5 = new JSONArray();
            BillRegisterApplyX2 = new JSONObject();
            array5.add((Object)BillRegisterApplyX2);
            body.put("BillRegisterApplyX2", (Object)array5);
            String acpFlg = info.getAcpFlg();
            acpFlg = "2";
            GetMessage4Register impl = new GetMessage4Register();
            EBBankNotePayableResponse ebBankNotePayableResponse = impl.doBiz(request);
            List message = ebBankNotePayableResponse.getNotePayableInfos();
            BillRegisterApplyX2.put("acpFlg", (Object)acpFlg);
            BillRegisterApplyX2.put("lmtTyp", (Object)"1");
            String acpFer = info.getAcpFer();
            if (StringUtils.isEmpty((String)acpFer)) {
                acpFer = RequestContextUtils.getBankParameterValue((String)"acpFer");
            }
            if (StringUtils.isEmpty((String)acpFer)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u627f\u5151\u624b\u7eed\u8d39\u4e0d\u80fd\u4e3a\u7a7a", (String)"RegisterNotePayableImpl_10", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            }
            BillRegisterApplyX2.put("acpFer", (Object)acpFer);
            String balTyp = info.getBalTyp();
            if (!StringUtils.isEmpty((String)balTyp)) {
                BillRegisterApplyX2.put("balTyp", (Object)balTyp);
            }
            if (!StringUtils.isEmpty((String)(balEac = info.getBalEac()))) {
                BillRegisterApplyX2.put("balEac", (Object)balEac);
            }
            String lmtBbk = ((NotePayableInfo)message.get(0)).getReserved1();
            String lmtBnr = ((NotePayableInfo)message.get(0)).getContractNo();
            if (StringUtils.isEmpty((String)lmtBbk) || StringUtils.isEmpty((String)lmtBnr)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bnkbilnegqry\u83b7\u53d6\u5230\u7684\u884c\u540d\u4e0e\u5408\u540c\u53f7\u4e3a\u7a7a\uff0c\u94f6\u627f\u51fa\u7968\u5931\u8d25", (String)"RegisterNotePayableImpl_9", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            }
            BillRegisterApplyX2.put("lmtBbk", (Object)lmtBbk);
            BillRegisterApplyX2.put("lmtBnr", (Object)lmtBnr);
        } else {
            array5 = new JSONArray();
            BillRegisterApplyX2 = new JSONObject();
            array5.add((Object)BillRegisterApplyX2);
            body.put("BillRegisterApplyX2", (Object)array5);
            BillRegisterApplyX2.put("acpFlg", (Object)"2");
        }
        JSONArray array6 = new JSONArray();
        JSONObject busOprIpt = new JSONObject();
        busOprIpt.put("busOprIpt", (Object)batchBusOprX1);
        array6.add((Object)busOprIpt);
        body.put("batchDetail", (Object)array6);
        JSONArray array7 = new JSONArray();
        JSONObject sceneDataMap = new JSONObject();
        busOprIpt.put("busOprIpt", (Object)batchBusOprX1);
        array7.add((Object)sceneDataMap);
        JSONObject BillRegisterApplyBillX1 = new JSONObject();
        BillRegisterApplyBillX1.put("BillRegisterApplyBillX1", (Object)array7);
        busOprIpt.put("sceneDataMap", (Object)BillRegisterApplyBillX1);
        sceneDataMap.put("bilTyp", (Object)info.getDraftType());
        sceneDataMap.put("bilCcy", (Object)"10");
        sceneDataMap.put("bilAmt", (Object)(info.getAmount() + ""));
        sceneDataMap.put("issDat", (Object)LocalDateUtil.formatDate((LocalDate)info.getBookingDate()));
        sceneDataMap.put("dueDat", (Object)LocalDateUtil.formatDate((LocalDate)info.getDueDate()));
        if (!StringUtils.isEmpty((String)info.getExplanation())) {
            sceneDataMap.put("bilRmk", (Object)info.getExplanation());
        }
        sceneDataMap.put("bilTrf", (Object)info.getTransferFlag());
        String grdBag = info.getGrdBag();
        if (StringUtils.isEmpty((String)grdBag)) {
            sceneDataMap.put("divFlg", (Object)"N");
        } else if ("0".equals(grdBag)) {
            sceneDataMap.put("divFlg", (Object)"N");
        } else {
            sceneDataMap.put("divFlg", (Object)"Y");
        }
        sceneDataMap.put("drwNam", (Object)info.getDrawerAccName());
        sceneDataMap.put("drwBrd", (Object)info.getDrawerBankCnaps());
        sceneDataMap.put("drwEac", (Object)info.getDrawerAccNo());
        sceneDataMap.put("acpNam", (Object)info.getAcceptorAccName());
        sceneDataMap.put("acpBrd", (Object)info.getAcceptorBankCnaps());
        if ("AC02".equals(info.getDraftType())) {
            sceneDataMap.put("acpEac", (Object)info.getAcceptorAccNo());
        }
        sceneDataMap.put("pyeNam", (Object)info.getPayeeAccName());
        sceneDataMap.put("pyeBrd", (Object)info.getPayeeBankCnaps());
        sceneDataMap.put("pyeBcd", (Object)info.getPayeeBankCnaps());
        sceneDataMap.put("pyeEac", (Object)info.getPayeeAccNo());
        sceneDataMap.put("cltRef", (Object)info.getBankDetailSeqId());
        if (StringUtils.isEmpty((String)info.getExplanation())) {
            sceneDataMap.put("useInf", (Object)ResManager.loadKDString((String)"\u5f00\u7968", (String)"RegisterNotePayableImpl_8", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        } else {
            sceneDataMap.put("useInf", (Object)info.getExplanation());
        }
        JSONObject head = JsonUtil.getHead("billregister", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, logger, this.getBizCode());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        ParserPayable.parsePay(request.getNotePayableInfoList(), responseStr);
        return request.getNotePayableInfoList();
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

