/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.receivable.signin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.receivable.signin.QuerySigninNoteReceivableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserReceivable;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class SigninNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SigninNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QuerySigninNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "combusreply";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u7b7e\u6536", (String)"SigninNoteReceivableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NoteReceivableInfo> infos = this.parse(request, rspStr);
            return new EBBankNoteReceivableResponse(infos);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNoteReceivableResponse(request.getNoteReceivableInfos());
        }
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        String startNo = receivableInfos[0].getStartNo();
        String endNo = receivableInfos[0].getEndNo();
        String code = receivableInfos[0].getOperationCode();
        String busSty = "";
        if ("10".equals(code)) {
            code = "BC07";
            busSty = "04";
        } else if ("03".equals(code)) {
            code = "BC03";
            busSty = "02";
        } else if ("02".equals(code)) {
            code = "BC02";
            busSty = "01";
        } else if ("20".equals(code)) {
            code = "BC13";
            busSty = "07";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7b7e\u6536\u7c7b\u578b\uff1a%s\u3002", (String)"SigninNoteReceivableImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), code));
        }
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject cltTrsDetailEdcInpDto = new JSONObject();
        cltTrsDetailEdcInpDto.put("cnlRef", (Object)SaasUtil.getRnlRef(receivableInfos[0].getBankBatchSeqId()));
        cltTrsDetailEdcInpDto.put("flwTyp", (Object)"ND0010");
        String flwCod = BankBusinessConfig.getBusMod(receivableInfos[0].getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u9875\u9762\u7ef4\u62a4\u3002", (String)"SigninNoteReceivableImpl_3", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        cltTrsDetailEdcInpDto.put("flwCod", (Object)flwCod);
        cltTrsDetailEdcInpDto.put("busTyp", (Object)"SF");
        cltTrsDetailEdcInpDto.put("busSty", (Object)"DFT");
        cltTrsDetailEdcInpDto.put("busTrs", (Object)"IN");
        cltTrsDetailEdcInpDto.put("busStr", (Object)"DFT");
        cltTrsDetailEdcInpDto.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        cltTrsDetailEdcInpDto.put("sndEac", (Object)receivableInfos[0].getDrawerAccNo());
        cltTrsDetailEdcInpDto.put("ccyNbr", (Object)"10");
        cltTrsDetailEdcInpDto.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        cltTrsDetailEdcInpDto.put("bchCnt", (Object)"1");
        cltTrsDetailEdcInpDto.put("bchTyp", (Object)"OPR");
        array2.add((Object)cltTrsDetailEdcInpDto);
        body.put("batchBusOprX1", (Object)array2);
        JSONArray array6 = new JSONArray();
        JSONObject busOprIpt = new JSONObject();
        JSONObject busOprIptInner = new JSONObject();
        busOprIptInner.put("cnlRef", (Object)SaasUtil.getRnlRef(receivableInfos[0].getBankBatchSeqId()));
        busOprIptInner.put("busTyp", (Object)"SF");
        busOprIptInner.put("busSty", (Object)busSty);
        busOprIptInner.put("busTrs", (Object)"IN");
        busOprIptInner.put("trsAmt", (Object)receivableInfos[0].getAmount().toString());
        busOprIptInner.put("busStr", (Object)receivableInfos[0].getDraftType());
        busOprIptInner.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        busOprIpt.put("busOprIpt", (Object)busOprIptInner);
        array6.add((Object)busOprIpt);
        body.put("batchDetail", (Object)array6);
        JSONArray array7 = new JSONArray();
        JSONObject sceneDataMap = new JSONObject();
        array7.add((Object)sceneDataMap);
        JSONObject sceneDataMapObject = new JSONObject();
        sceneDataMapObject.put("ComReplyDtlX1", (Object)array7);
        busOprIpt.put("sceneDataMap", (Object)sceneDataMapObject);
        String refKey = receivableInfos[0].getBankRefKey();
        if (StringUtils.isEmpty((String)refKey)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u8003\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SigninNoteReceivableImpl_4", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        String[] refKeys = refKey.split("\\|");
        sceneDataMap.put("busSeq", (Object)refKeys[0]);
        sceneDataMap.put("busCod", (Object)refKeys[3]);
        sceneDataMap.put("prdIst", (Object)refKeys[2]);
        sceneDataMap.put("innNbr", (Object)refKeys[1]);
        sceneDataMap.put("bilNbr", (Object)receivableInfos[0].getBillNo());
        sceneDataMap.put("bilSbs", (Object)startNo);
        sceneDataMap.put("bilSbe", (Object)endNo);
        sceneDataMap.put("bilTyp", (Object)receivableInfos[0].getDraftType());
        sceneDataMap.put("bilCcy", (Object)"10");
        sceneDataMap.put("bilAmt", (Object)receivableInfos[0].getAmount().toString());
        sceneDataMap.put("busRef", (Object)receivableInfos[0].getBankBatchSeqId());
        if ("BC02".equals(refKeys[3])) {
            sceneDataMap.put("payPmt", (Object)"CC00");
        }
        if ("SU01".equals(receivableInfos[0].getOtherInfo())) {
            sceneDataMap.put("rfsCod", (Object)"CP07");
            if (StringUtils.isEmpty((String)receivableInfos[0].getExplanation())) {
                sceneDataMap.put("rfsTxt", (Object)ResManager.loadKDString((String)"\u62d2\u7edd\u7b7e\u6536", (String)"SigninNoteReceivableImpl_5", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
            } else {
                sceneDataMap.put("rfsTxt", (Object)receivableInfos[0].getExplanation());
            }
        }
        JSONArray array8 = new JSONArray();
        JSONObject ComReplyBchX1 = new JSONObject();
        array8.add((Object)ComReplyBchX1);
        ComReplyBchX1.put("cltEac", (Object)acnt.getAccNo());
        ComReplyBchX1.put("reqSrc", (Object)"CS02");
        ComReplyBchX1.put("cnlCod", (Object)"EDC");
        ComReplyBchX1.put("ansCod", (Object)receivableInfos[0].getOtherInfo());
        ComReplyBchX1.put("prxAns", (Object)"PS01");
        if (!StringUtils.isEmpty((String)receivableInfos[0].getExplanation())) {
            ComReplyBchX1.put("cltRem", (Object)receivableInfos[0].getExplanation());
        }
        body.put("ComReplyBchX1", (Object)array8);
        JSONObject head = JsonUtil.getHead("combusreply", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, logger, "combusreply");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        ParserReceivable.parsePay(bankNoteReceivableRequest.getNoteReceivableInfos(), rsp);
        return bankNoteReceivableRequest.getNoteReceivableInfos();
    }
}

