/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.payable.register;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.payable.QueryResultUtil;
import kd.ebg.note.banks.spdb.dc.services.codeless.payable.register.QueryRegisterImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CodelessRegisterImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 20;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ02";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u7968\u51fa\u7968\u63a5\u53e3", (String)"CodelessRegisterImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest request, String s) {
        NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)(infos.length + ""));
        JDomUtils.addChild((Element)root, (String)"totalAmount", (String)this.getTotalAmount(infos));
        String acceptanceType = "00";
        JDomUtils.addChild((Element)root, (String)"acceptanceType", (String)acceptanceType);
        String acceptorBankName = infos[0].getAcceptorBankName();
        String sameBank = SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)acceptorBankName);
        if ("1".equals(sameBank)) {
            if ("1".equals(infos[0].getAutoReceive()) && "1".equals(infos[0].getAutoAccept())) {
                if ("AC01".equals(infos[0].getDraftType())) {
                    JDomUtils.addChild((Element)root, (String)"eDraweringTxType", (String)"03");
                    EBGNotePayableUtils.setBatchNo((List)request.getNotePayableInfoList(), (String)"3");
                } else {
                    JDomUtils.addChild((Element)root, (String)"eDraweringTxType", (String)"02");
                    EBGNotePayableUtils.setBatchNo((List)request.getNotePayableInfoList(), (String)"2");
                }
            } else if ("1".equals(infos[0].getAutoAccept())) {
                JDomUtils.addChild((Element)root, (String)"eDraweringTxType", (String)"02");
                EBGNotePayableUtils.setBatchNo((List)request.getNotePayableInfoList(), (String)"2");
            } else if ("AC01".equals(infos[0].getDraftType())) {
                JDomUtils.addChild((Element)root, (String)"eDraweringTxType", (String)"02");
                EBGNotePayableUtils.setBatchNo((List)request.getNotePayableInfoList(), (String)"2");
            } else {
                JDomUtils.addChild((Element)root, (String)"eDraweringTxType", (String)"01");
                EBGNotePayableUtils.setBatchNo((List)request.getNotePayableInfoList(), (String)"1");
            }
        } else {
            JDomUtils.addChild((Element)root, (String)"eDraweringTxType", (String)"01");
        }
        JDomUtils.addChild((Element)root, (String)"eBillType", (String)infos[0].getDraftType());
        JDomUtils.addChild((Element)root, (String)"acctNo", (String)infos[0].getDrawerAccNo());
        JDomUtils.addChild((Element)root, (String)"eBillingType", (String)"01");
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo()));
        Element lists = new Element("lists");
        lists.setAttribute("name", "edraftList");
        JDomUtils.addChild((Element)root, (Element)lists);
        for (int i = 0; i < infos.length; ++i) {
            Element list = new Element("list");
            JDomUtils.addChild((Element)lists, (Element)list);
            String seqNo = String.format("%04d", Integer.parseInt(infos[i].getBankSerialNo()));
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)seqNo);
            JDomUtils.addChild((Element)list, (String)"voteDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
            JDomUtils.addChild((Element)list, (String)"expiryDate", (String)LocalDateUtil.formatDate((LocalDate)infos[i].getDueDate()));
            JDomUtils.addChild((Element)list, (String)"unpackFlag", (String)infos[i].getGrdBag());
            JDomUtils.addChild((Element)list, (String)"acceptorAcctName", (String)infos[i].getAcceptorAccName());
            JDomUtils.addChild((Element)list, (String)"acceptorAcctNo", (String)infos[i].getAcceptorAccNo());
            JDomUtils.addChild((Element)list, (String)"acceptorBankNo", (String)infos[i].getAcceptorBankCnaps());
            JDomUtils.addChild((Element)list, (String)"acceptorBankName", (String)infos[i].getAcceptorBankName());
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)infos[i].getAmount().toPlainString());
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)infos[i].getTransferFlag());
            JDomUtils.addChild((Element)list, (String)"ePayeeAcctName", (String)infos[i].getPayeeAccName());
            JDomUtils.addChild((Element)list, (String)"ePayeeAcctNo", (String)infos[i].getPayeeAccNo());
            JDomUtils.addChild((Element)list, (String)"ePayeeBankNo", (String)infos[i].getPayeeBankCnaps());
            JDomUtils.addChild((Element)list, (String)"ePayeeBankName", (String)infos[i].getPayeeBankName());
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("PJ02", signedMsg);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String rspStr) {
        List infos = request.getNotePayableInfoList();
        QueryResultUtil.parserCommon(infos, rspStr);
        return infos;
    }

    String getTotalAmount(NotePayableInfo[] infos) {
        BigDecimal total = new BigDecimal("0");
        for (int i = 0; i < infos.length; ++i) {
            total = total.add(infos[i].getAmount());
        }
        return total.toString();
    }
}

