/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.payable.cancel;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.payable.cancel.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNotePayableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String code = info.getOperationCode();
        this.logger.info("\u8fdb\u5165\u64a4\u9500\u5904\u7406\u7c7b\uff1a" + code);
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        this.logger.info("\u64a4\u9500\u64cd\u4f5c\u83b7\u53d6\u5230\u7684\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)info.getReserved1());
        JDomUtils.addChild((Element)body, (String)"eBillBusinessId", (String)info.getReserved1());
        JDomUtils.addChild((Element)body, (String)"billNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)body, (String)"eBillAmount", (String)(info.getAmount() + ""));
        JDomUtils.addChild((Element)body, (String)"oldTransDate", (String)info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"oldTransJnlNo", (String)info.getObssid());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE05", signedMsg);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return notePayableInfos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            String message = body.getChildTextTrim("returnMsg");
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        } else {
            String businessId = body.getChildText("businessId");
            ((NotePayableInfo)notePayableInfos.get(0)).setObssid(businessId);
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u64a4\u9500", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

