/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryCancleNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCancleNoteReceivableImpl.class);

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        this.logger.info("\u8d34\u73b0\u67e5\u8be2\u5f00\u59cb\uff0cbatchID\u4e3a{}", (Object)info.getBankRefKey());
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"hostTxnCode", (String)"FE05");
        JDomUtils.addChild((Element)body, (String)"transJnlNo");
        JDomUtils.addChild((Element)body, (String)"businessId", (String)info.getBankRefKey());
        JDomUtils.addChild((Element)body, (String)"beginDate");
        JDomUtils.addChild((Element)body, (String)"endDate");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"   1");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"  20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE26", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
            Element dtlListElement = body.getChild("lists");
            String result = "";
            String noteStatus = "";
            int index = 0;
            List dtlLists = dtlListElement.getChildren("list");
            for (Element rs : dtlLists) {
                result = rs.getChildText("eBillJnlStatus");
                index = dtlLists.indexOf(rs);
                noteStatus = rs.getChildText("eBillStatus");
                switch (result) {
                    case "1": {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)((NoteReceivableInfo)infos.get(index)), (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"QueryCancleNoteReceivableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        ((NoteReceivableInfo)infos.get(index)).setNoteStatus(noteStatus);
                        break;
                    }
                    case "2": {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)((NoteReceivableInfo)infos.get(index)), (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"QueryCancleNoteReceivableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "3": {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)((NoteReceivableInfo)infos.get(index)), (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5df2\u64a4\u9500", (String)"QueryCancleNoteReceivableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "4": {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)((NoteReceivableInfo)infos.get(index)), (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5df2\u7ecf\u53d1\u9001\u5230\u5bf9\u65b9\u3002", (String)"QueryCancleNoteReceivableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        ((NoteReceivableInfo)infos.get(index)).setNoteStatus(noteStatus);
                        break;
                    }
                    case "5": {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)((NoteReceivableInfo)infos.get(index)), (PaymentState)PaymentState.SUCCESS, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5df2\u7b7e\u6536", (String)"QueryCancleNoteReceivableImpl_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        ((NoteReceivableInfo)infos.get(index)).setNoteStatus(noteStatus);
                    }
                }
            }
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u7ed3\u679c\u672a\u77e5\u3002", (String)"QueryCancleNoteReceivableImpl_5", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        return infos;
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500\u540c\u6b65", (String)"QueryCancleNoteReceivableImpl_6", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }
}

