/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.payment;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.banks.spdb.dc.services.util.Utils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentNoteReceivableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        this.logger.info("\u63d0\u793a\u4ed8\u6b3e\u6253\u5305\u5f00\u59cb");
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        BankAcnt acnt = request.getAcnt();
        int length = receivableInfos.size();
        BigDecimal totalAmount = BigDecimal.ZERO;
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)Utils.fixed(length + "", " ", 4, false));
        JDomUtils.addChild((Element)body, (String)"remark");
        Element cycle = Packer.creatCycleMessage();
        JDomUtils.addChild((Element)body, (Element)cycle);
        for (NoteReceivableInfo p : receivableInfos) {
            BigDecimal eBillAmount = p.getAmount();
            totalAmount = eBillAmount.add(totalAmount);
            Element list = JDomUtils.addChild((Element)cycle, (String)"list");
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)String.format("%04d", receivableInfos.indexOf(p)));
            JDomUtils.addChild((Element)list, (String)"billNo", (String)info.getBillNo());
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)p.getAmount().toPlainString());
            JDomUtils.addChild((Element)list, (String)"cuePayType", (String)"01");
            JDomUtils.addChild((Element)list, (String)"cuePayerName", (String)acnt.getAccName());
            JDomUtils.addChild((Element)list, (String)"cuePayerType", (String)"RC01");
            JDomUtils.addChild((Element)list, (String)"cuePayerAcctNo", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)list, (String)"bondeeBankNo");
            LocalDate nowLocal = p.getDueDate();
            Date succ = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            JDomUtils.addChild((Element)list, (String)"cuePayApplyDate", (String)p.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)list, (String)"cuePayAmount", (String)eBillAmount.toPlainString());
            if ("0".equals(p.getAutoAccept())) {
                JDomUtils.addChild((Element)list, (String)"lineLiquidationFlag", (String)"SM00");
            } else {
                JDomUtils.addChild((Element)list, (String)"lineLiquidationFlag", (String)"SM01");
            }
            if (DateTimeUtils.dayBefore((Date)succ, (Date)new Date())) {
                JDomUtils.addChild((Element)list, (String)"overdueRemark", (String)p.getExplanation());
                continue;
            }
            JDomUtils.addChild((Element)list, (String)"overdueRemark");
        }
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)totalAmount.toPlainString());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE14", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        this.logger.info("\u63d0\u793a\u4ed8\u6b3e\u89e3\u6790\u5f00\u59cb");
        List infos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return infos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String businessId = body.getChildText("businessId");
            if (StringUtils.isEmpty((String)businessId)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u7968\u636e\u94f6\u884c\u672a\u8fd4\u56debusinessId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                ((NoteReceivableInfo)infos.get(0)).setBankRefKey(businessId);
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else {
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

