/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable.discount;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.discount.QueryDiscountReceivableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableDiscountNoteImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountReceivableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC62";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u7533\u8bf7", (String)"ReceivableDiscountNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRC62", receivableInfos[0].getBankBatchSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1046", "");
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)CustInf, (String)"ConAcctSvcr", (String)"");
        Element BillInfList = JDomUtils.addChild((Element)hermes, (String)"BillInfList");
        Element BillInf = JDomUtils.addChild((Element)BillInfList, (String)"BillInf");
        JDomUtils.addChild((Element)BillInf, (String)"CdNo", (String)receivableInfos[0].getBillNo());
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(receivableInfos[0].getStartNo()));
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(receivableInfos[0].getEndNo()));
        Element BusiInf = JDomUtils.addChild((Element)BillInf, (String)"BusiInf");
        JDomUtils.addChild((Element)BusiInf, (String)"DscAppAmt", (String)receivableInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)BusiInf, (String)"DsctInt", (String)receivableInfos[0].getInterest());
        JDomUtils.addChild((Element)BusiInf, (String)"SetAmt", (String)receivableInfos[0].getDisCountAmount());
        JDomUtils.addChild((Element)BusiInf, (String)"SerNo", (String)"1");
        Element ComBusiInf = JDomUtils.addChild((Element)hermes, (String)"ComBusiInf");
        JDomUtils.addChild((Element)ComBusiInf, (String)"AppDt", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)ComBusiInf, (String)"BnedMtmrk", (String)receivableInfos[0].getTransferFlag());
        JDomUtils.addChild((Element)ComBusiInf, (String)"BtNo", (String)receivableInfos[0].getBankBatchSeqId());
        BigDecimal rate = new BigDecimal(receivableInfos[0].getDisCountRate()).divide(new BigDecimal("100"));
        JDomUtils.addChild((Element)ComBusiInf, (String)"DsctRt", (String)rate.toPlainString());
        JDomUtils.addChild((Element)ComBusiInf, (String)"Note", (String)receivableInfos[0].getExplanation());
        Element DscOrgInf = JDomUtils.addChild((Element)hermes, (String)"DscOrgInf");
        JDomUtils.addChild((Element)DscOrgInf, (String)"AcctSvcr", (String)receivableInfos[0].getPayeeBankCnaps());
        Element StlInf = JDomUtils.addChild((Element)hermes, (String)"StlInf");
        String payeeBankName = receivableInfos[0].getPayeeBankName();
        if ("1".equals(receivableInfos[0].getIsPayeeSameBank())) {
            JDomUtils.addChild((Element)StlInf, (String)"SetMode", (String)"ST02");
        } else {
            JDomUtils.addChild((Element)StlInf, (String)"SetMode", (String)"ST01");
        }
        JDomUtils.addChild((Element)StlInf, (String)"ClrTp", (String)"CT01");
        JDomUtils.addChild((Element)StlInf, (String)"StlDt", (String)DateUtil.formatDate((Date)new Date()));
        Element AcctInf = JDomUtils.addChild((Element)StlInf, (String)"AcctInf");
        JDomUtils.addChild((Element)AcctInf, (String)"Name", (String)receivableInfos[0].getAcceptorAccName());
        JDomUtils.addChild((Element)AcctInf, (String)"Acct", (String)receivableInfos[0].getAcceptorAccNo());
        JDomUtils.addChild((Element)AcctInf, (String)"AcctSvcr", (String)receivableInfos[0].getAcceptorBankCnaps());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NewNoteParser.parseDiscount(bankNoteReceivableRequest, s);
        return bankNoteReceivableRequest.getNoteReceivableInfos();
    }
}

