/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.payable.cancle;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.payable.cancle.DetailUtil;
import kd.ebg.note.banks.abc.dc.service.note.payable.cancle.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0106";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u7533\u8bf7\u64a4\u56de(b2e0106)", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT57");
        Element hermes = CommNotePacker.packNoteHeader(root, "0320");
        Element cmp = CommNotePacker.packCmpElement(root, acnt);
        if (MatchUtils.isSameBank(EBContext.getContext().getBankVersionID(), info.getPayeeBankName()) && info.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount().toString());
        Element ebinfo = JDomUtils.addChild((Element)hermes, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)info.getBillNo());
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info.getDraftType());
        JDomUtils.addChild((Element)ebinfo, (String)"TransFlg", (String)info.getTransferFlag());
        if (null == info.getBookingDate()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u51fa\u7968\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CancleNotePayableImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        if (null == info.getDueDate()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u5230\u671f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CancleNotePayableImpl_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        String IssDat = info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String duedate = info.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)IssDat);
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        Element cpdinfo = JDomUtils.addChild((Element)hermes, (String)"CPDInfo");
        JDomUtils.addChild((Element)cpdinfo, (String)"CpdNam", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)cpdinfo, (String)"CpdOpBnk", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)cpdinfo, (String)"CpdOpBnkNam", (String)info.getPayeeBankName());
        Element cxlPropsr = JDomUtils.addChild((Element)hermes, (String)"CxlPropsr");
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpTyp", (String)"RC01");
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpOpBnk", (String)info.getDrawerBankCnaps());
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpOpBnkNam", (String)acnt.getBankName());
        Element speInfo = JDomUtils.addChild((Element)hermes, (String)"SpeInfo");
        String operationCode = info.getOperationCode();
        String type = "";
        if (!"03".equals(operationCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u64a4\u9500\u7c7b\u578b(operationCode)\uff1a%s\u3002", (String)"CancleNotePayableImpl_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), operationCode));
        }
        type = "TRE004";
        String busCode = new DetailUtil().getStatus(info.getBillNo(), type);
        if (StringUtils.isEmpty((String)busCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a\u7a7a", (String)"CancleNotePayableImpl_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        this.logger.info("\u4e1a\u52a1\u7f16\u7801(BusCode)=" + busCode);
        JDomUtils.addChild((Element)speInfo, (String)"BusCode", (String)busCode);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfoList = request.getNotePayableInfoList();
        CommNotePacker.parserNotePay(notePayableInfoList, responseStr);
        return notePayableInfoList;
    }
}

