/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.receivable.cancle;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.payable.cancle.DetailUtil;
import kd.ebg.note.banks.abc.dc.service.note.receivable.cancle.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CFRT57";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u7533\u8bf7\u64a4\u56de(CFRT57)", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT57");
        Element hermes = CommNotePacker.packNoteHeader(root, "0320");
        Element cmp = CommNotePacker.packCmpElement(root, acnt);
        if (MatchUtils.isSameBank(info) && info.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount().toString());
        Element ebinfo = JDomUtils.addChild((Element)hermes, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)info.getBillNo());
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info.getDraftType());
        JDomUtils.addChild((Element)ebinfo, (String)"TransFlg", (String)info.getTransferFlag());
        if (null == info.getIssueDate()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u51fa\u7968\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CancleNoteReceivableImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        if (null == info.getDueDate()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u5230\u671f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CancleNoteReceivableImpl_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        String IssDat = info.getIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String duedate = info.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)IssDat);
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        Element cpdinfo = JDomUtils.addChild((Element)hermes, (String)"CPDInfo");
        JDomUtils.addChild((Element)cpdinfo, (String)"CpdNam", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)cpdinfo, (String)"CpdOpBnk", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)cpdinfo, (String)"CpdOpBnkNam", (String)info.getPayeeBankName());
        Element cxlPropsr = JDomUtils.addChild((Element)hermes, (String)"CxlPropsr");
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpTyp", (String)"RC01");
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpOpBnk", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)cxlPropsr, (String)"CpOpBnkNam", (String)acnt.getBankName());
        Element speInfo = JDomUtils.addChild((Element)hermes, (String)"SpeInfo");
        String operationCode = info.getOperationCode();
        String type = "";
        if ("10".equals(operationCode)) {
            type = "TRE006";
        } else if ("18".equals(operationCode)) {
            type = "TRE012";
        } else if ("19".equals(operationCode)) {
            type = "TRE013";
        } else if ("20".equals(operationCode)) {
            type = "TRE015";
        } else if ("11".equals(operationCode)) {
            type = "TRE007";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s\u3002", (String)"CancleNoteReceivableImpl_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), operationCode));
        }
        this.logger.info("\u67e5\u8be2\u53ef\u64a4\u9500\u7968\u636e(CQRM03) \u83b7\u53d6\u4e1a\u52a1\u7f16\u7801(BusCode)");
        String busCode = new DetailUtil().getStatus(info.getBillNo(), type);
        if (StringUtils.isEmpty((String)busCode)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7\u4e3a\u7a7a", (String)"CancleNoteReceivableImpl_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        this.logger.info("\u4e1a\u52a1\u7f16\u7801(BusCode)=" + busCode);
        JDomUtils.addChild((Element)speInfo, (String)"BusCode", (String)busCode);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        CommNotePacker.parserNoteReq(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }
}

