/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.receivable.payment;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0111";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u63d0\u793a\u4ed8\u6b3e(b2e0111)", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT58");
        Element hermes = CommNotePacker.packNoteHeader(root, "0200");
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount().setScale(2).toString());
        if (MatchUtils.isSameBank(info) && info.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        Element ebinfo = JDomUtils.addChild((Element)hermes, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info.getDraftType());
        String IssDat = info.getIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String duedate = info.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        if (StringUtils.isEmpty((String)testServerDate)) {
            JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)IssDat);
        } else {
            JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)testServerDate);
        }
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        JDomUtils.addChild((Element)ebinfo, (String)"TransFlg", (String)info.getTransferFlag());
        if (StringUtils.isEmpty((String)info.getBillNo())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e\u8bf7\u6c42\u8d26\u53f7%s\u7f3a\u5c11\u7968\u636e\u53f7\u7801\u3002", (String)"PaymentNoteReceivableImpl_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), acnt.getAccNo()));
        }
        JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)info.getBillNo());
        Element prsnttn = JDomUtils.addChild((Element)hermes, (String)"Prsnttn");
        JDomUtils.addChild((Element)prsnttn, (String)"Amt", (String)info.getAmount().setScale(2).toString());
        JDomUtils.addChild((Element)prsnttn, (String)"OnlineFlg", (String)info.getOtherInfo());
        if ("SM01".equals(info.getOtherInfo())) {
            JDomUtils.addChild((Element)prsnttn, (String)"OnlineFlgNam", (String)ResManager.loadKDString((String)"\u7ebf\u4e0b\u4ed8\u6b3e", (String)"PaymentNoteReceivableImpl_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        } else if ("SM00".equals(info.getOtherInfo())) {
            JDomUtils.addChild((Element)prsnttn, (String)"OnlineFlgNam", (String)ResManager.loadKDString((String)"\u7968\u6b3e\u5bf9\u4ed8", (String)"PaymentNoteReceivableImpl_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        } else {
            JDomUtils.addChild((Element)prsnttn, (String)"OnlineFlgNam", (String)"");
        }
        if ("21".equals(info.getOperationCode())) {
            JDomUtils.addChild((Element)prsnttn, (String)"UnExpire", (String)"DPF001");
            JDomUtils.addChild((Element)prsnttn, (String)"IsExpire", (String)"1");
        } else {
            JDomUtils.addChild((Element)prsnttn, (String)"UnExpire", (String)"DPF000");
            JDomUtils.addChild((Element)prsnttn, (String)"IsExpire", (String)"0");
        }
        JDomUtils.addChild((Element)prsnttn, (String)"ExpireReason", (String)info.getExplanation());
        Element accepterInfo = JDomUtils.addChild((Element)hermes, (String)"AccepterInfo");
        JDomUtils.addChild((Element)accepterInfo, (String)"AcepOpBnk", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)accepterInfo, (String)"AcepOpBnkNam", (String)info.getPayeeBankName());
        if ("AC01".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)accepterInfo, (String)"AcepNam", (String)info.getPayeeAccName());
            JDomUtils.addChild((Element)accepterInfo, (String)"AcepAccNo", (String)"0");
        } else {
            JDomUtils.addChild((Element)accepterInfo, (String)"AcepNam", (String)info.getPayeeAccName());
            JDomUtils.addChild((Element)accepterInfo, (String)"AcepAccNo", (String)info.getPayeeAccNo());
        }
        Element drgtHldr = JDomUtils.addChild((Element)hermes, (String)"DrgtHldr");
        JDomUtils.addChild((Element)drgtHldr, (String)"DrgNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)drgtHldr, (String)"DrgTyp", (String)"RC01");
        JDomUtils.addChild((Element)drgtHldr, (String)"DrgOpBnk", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)drgtHldr, (String)"DrgOpBnkNam", (String)acnt.getBankName());
        JDomUtils.addChild((Element)drgtHldr, (String)"DrgConBnk", (String)"");
        JDomUtils.addChild((Element)drgtHldr, (String)"DrgConBnkNam", (String)"");
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        CommNotePacker.parserNoteReq(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }
}

