/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static void createSystemHead(Element root) throws EBServiceException {
        String cifNo = RequestContextUtils.getBankParameterValue((String)"CifNo");
        String operatorID = RequestContextUtils.getBankParameterValue((String)"OperatorID");
        Element systemHead = new Element("SystemHead");
        JDomUtils.addChild((Element)systemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)systemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"CifNo", (String)cifNo);
        JDomUtils.addChild((Element)systemHead, (String)"UserID", (String)operatorID);
        JDomUtils.addChild((Element)systemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Note", (String)"");
        JDomUtils.addChild((Element)root, (Element)systemHead);
    }

    public static Element createTransHead(String transCode, String batchID) throws EBServiceException {
        Element TransHead = new Element("TransHead");
        JDomUtils.addChild((Element)TransHead, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)TransHead, (String)"BatchID", (String)batchID);
        Date now = new Date();
        JDomUtils.addChild((Element)TransHead, (String)"JnlDate", (String)DateUtil.formatDate((Date)now));
        JDomUtils.addChild((Element)TransHead, (String)"JnlTime", (String)new SimpleDateFormat("HHmmss").format(now));
        return TransHead;
    }

    public static String formatDate(Date date) {
        return DateTimeUtils.format((Date)date).replace(' ', 'T');
    }

    public static String createBatchID() throws EBServiceException {
        String userID = RequestContextUtils.getBankParameterValue((String)"UserID");
        return userID + DateUtil.formatDate((Date)new Date()) + Sequence.genSequence();
    }

    public static String createClientPatchID(String batchID, int index) {
        String str = "" + index;
        for (int i = 4 - str.length(); i > 0; --i) {
            str = "0" + str;
        }
        return batchID + str;
    }

    public static Element createNoteHead(String transCode) throws EBServiceException {
        String batchID = Packer.createBatchID();
        Element root = JDomUtils.createRoot((String)"Transaction");
        Packer.createSystemHead(root);
        Element transHead = Packer.createTransHead(transCode, batchID);
        JDomUtils.addChild((Element)root, (Element)transHead);
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)Packer.createClientPatchID(batchID, 0));
        return root;
    }

    public static Element createNoteHead(String transCode, String patchID) throws EBServiceException {
        String batchID = Packer.createBatchID();
        Element root = JDomUtils.createRoot((String)"Transaction");
        Packer.createSystemHead(root);
        Element transHead = Packer.createTransHead(transCode, batchID);
        JDomUtils.addChild((Element)root, (Element)transHead);
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)patchID);
        return root;
    }
}

