/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.payable.cancel.queryinfo;

import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryNoteParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteParser.class);

    public void parseQueryPay(NotePayableInfo[] notePayableInfos, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        if (!"0000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Namespace ns = root.getNamespace();
        Element respData = root.getChild("TransContent", ns).getChild("RespData", ns);
        String billStatus = respData.getChildText("BillStatus", ns);
        String[] status = CEBHelper.CEBBILLSTATUS.get(billStatus);
        if (status == null) {
            EBGNotePayableUtils.setPaymentState(Arrays.asList(notePayableInfos), (PaymentState)PaymentState.UNKNOWN, (String)billStatus, (String)"");
        } else {
            String operationCode = notePayableInfos[0].getOperationCode();
            if ("02".equals(operationCode) && "A_01".equals(billStatus)) {
                notePayableInfos[0].setNoteStatus("010004");
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfos[0], (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u627f\u5151\u64a4\u9500\u6210\u529f", (String)"QueryNoteParser_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
            } else if ("03".equals(operationCode) && "B_02".equals(billStatus)) {
                notePayableInfos[0].setNoteStatus("020006");
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfos[0], (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u64a4\u9500\u6210\u529f", (String)"QueryNoteParser_1", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
            } else {
                if (status.length > 1) {
                    notePayableInfos[0].setNoteStatus(status[1]);
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)billStatus, (String)String.format(ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5\uff1a%s\u3002", (String)"QueryNoteParser_8", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]), response.getResponseMessage()));
            }
        }
        this.logger.info("\u540c\u6b65\u540e\u7968\u636e\u72b6\u6001\uff1a" + notePayableInfos[0].getStatus());
    }
}

