/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.receivable.endorse;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Packer;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class NotePacker {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NotePacker.class);

    public String packPay(NoteReceivableInfo[] receivableInfos) throws EBServiceException {
        NoteReceivableInfo info = receivableInfos[0];
        Element root = Packer.createNoteHead("b2e003019");
        Element reqData = root.getChild("TransContent").getChild("ReqData");
        JDomUtils.addChild((Element)reqData, (String)"BillId", (String)info.getBankRefKey());
        JDomUtils.addChild((Element)reqData, (String)"Isendo", (String)info.getTransferFlag());
        JDomUtils.addChild((Element)reqData, (String)"AcNo", (String)info.getDrawerAccNo());
        boolean isSameBank = false;
        if (SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        if (!isSameBank) {
            JDomUtils.addChild((Element)reqData, (String)"AcName2", (String)receivableInfos[0].getPayeeAccName());
        }
        JDomUtils.addChild((Element)reqData, (String)"AcNo2", (String)receivableInfos[0].getPayeeAccNo());
        JDomUtils.addChild((Element)reqData, (String)"BankType", (String)(isSameBank ? "0" : "1"));
        if (!isSameBank) {
            JDomUtils.addChild((Element)reqData, (String)"ToEndorseBankNo", (String)receivableInfos[0].getPayeeBankCnaps());
        }
        String ClientPatchID = reqData.getChildText("ClientPatchID");
        this.logger.info("\u53d1\u9001\u7684\u6d41\u6c34\u53f7\uff1a" + ClientPatchID);
        info.setRspserialno(ClientPatchID);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

