/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.receivable.payment;

import java.util.Arrays;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.util.QueryNotePayableUtil;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryParser.class);
    static String[] fail = new String[]{"D_07", "R_22", "R_23", "R_24"};

    public void parseQueryPay(NoteReceivableInfo[] receivableInfos, String rsp) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        if (!"0000".equals(response.getResponseCode())) {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Namespace ns = root.getNamespace();
        List respDatas = root.getChild("TransContent", ns).getChild("BatchRespList", ns).getChildren("RespData", ns);
        Element rs = null;
        String rsBillNo = "";
        for (Element data : respDatas) {
            if (!data.getChildText("BillNo", ns).equals(receivableInfos[0].getBillNo())) continue;
            rs = data;
            rsBillNo = data.getChildText("BillNo", ns);
            this.logger.info("\u5339\u914d\u6210\u529f");
            break;
        }
        if (StringUtils.isEmpty((String)rsBillNo)) {
            this.logger.info("\u5339\u914d\u5931\u8d25");
            return;
        }
        String BILLSTATUS = "";
        if (rs != null) {
            BILLSTATUS = rs.getChildText("BillStatus", ns);
        }
        String status = CEBHelper.BILLSTATUS.get(BILLSTATUS);
        String[] statusArray = CEBHelper.CEBBILLSTATUS.get(status);
        String[] success = new String[]{"R_16"};
        if (statusArray != null) {
            PaymentState state = CEBHelper.getNoteState(success, fail, BILLSTATUS);
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)state, (String)"", (String)BILLSTATUS);
            receivableInfos[0].setNoteStatus(statusArray[1]);
        } else {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)BILLSTATUS);
        }
    }
}

